/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.transactional;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.n52.javaps.algorithm.IAlgorithm;
import org.n52.javaps.description.TypedProcessDescription;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.javaps.transactional.DuplicateProcessException;
import org.n52.javaps.transactional.ListenableTransactionalAlgorithmRepository;
import org.n52.javaps.transactional.TransactionalAlgorithmRepositoryListener;
import org.n52.javaps.transactional.UndeletableApplicationPackage;
import org.n52.javaps.transactional.UndeletableProcessException;
import org.n52.javaps.transactional.UnsupportedProcessException;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.ap.ApplicationPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionalAlgorithmRepository
implements ListenableTransactionalAlgorithmRepository {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransactionalAlgorithmRepository.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<OwsCode, ApplicationPackage> applicationPackages = new HashMap<OwsCode, ApplicationPackage>();
    private Set<TransactionalAlgorithmRepositoryListener> listeners = new HashSet<TransactionalAlgorithmRepositoryListener>();

    @Override
    public void addListener(TransactionalAlgorithmRepositoryListener listener) {
        this.lock.writeLock().lock();
        try {
            LOG.debug("Adding listener {} to {}", (Object)listener, (Object)this);
            this.listeners.add(listener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeListener(TransactionalAlgorithmRepositoryListener listener) {
        this.lock.writeLock().lock();
        try {
            LOG.debug("Removing listener {} from {}", (Object)listener, (Object)this);
            this.listeners.remove(listener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<OwsCode> getAlgorithmNames() {
        this.lock.readLock().lock();
        try {
            HashSet<OwsCode> hashSet = new HashSet<OwsCode>(this.applicationPackages.keySet());
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Optional<TypedProcessDescription> getProcessDescription(OwsCode id) {
        Objects.requireNonNull(id);
        return this.getApplicationPackage(id).map(this::createProcessDescription);
    }

    @Override
    public boolean containsAlgorithm(OwsCode id) {
        Objects.requireNonNull(id);
        this.lock.readLock().lock();
        try {
            boolean bl = this.applicationPackages.containsKey(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<IAlgorithm> getAlgorithm(OwsCode id) {
        return this.getApplicationPackage(id).map(this::createAlgorithm);
    }

    @Override
    public Optional<ApplicationPackage> getApplicationPackage(OwsCode id) {
        Objects.requireNonNull(id);
        this.lock.readLock().lock();
        try {
            Optional<ApplicationPackage> optional = Optional.ofNullable(this.applicationPackages.get(id));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OwsCode register(ApplicationPackage applicationPackage) throws DuplicateProcessException, UnsupportedProcessException {
        Objects.requireNonNull(applicationPackage);
        LOG.debug("Registering application package {} to {}", (Object)applicationPackage, (Object)this);
        if (!this.isSupported(applicationPackage)) {
            throw new UnsupportedProcessException(String.format("unsupported application package %s", applicationPackage));
        }
        OwsCode id = applicationPackage.getProcessDescription().getProcessDescription().getId();
        this.lock.writeLock().lock();
        try {
            if (this.applicationPackages.containsKey(id)) {
                throw new DuplicateProcessException(id);
            }
            this.applicationPackages.put(id, applicationPackage);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.lock.readLock().lock();
        try {
            LOG.debug("Notifying listeners for new application package {}", (Object)applicationPackage);
            this.listeners.forEach(l -> l.onRegister(applicationPackage));
        }
        finally {
            this.lock.readLock().unlock();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(OwsCode id) throws ProcessNotFoundException, UndeletableProcessException {
        ApplicationPackage applicationPackage;
        Objects.requireNonNull(id);
        LOG.debug("Unregistering application package {} from {}", (Object)id, (Object)this);
        this.lock.writeLock().lock();
        try {
            applicationPackage = this.applicationPackages.get(id);
            if (applicationPackage == null) {
                throw new ProcessNotFoundException(id);
            }
            if (applicationPackage instanceof UndeletableApplicationPackage) {
                throw new UndeletableProcessException(id);
            }
            this.applicationPackages.remove(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.lock.readLock().lock();
        try {
            LOG.debug("Notifying listeners for removed application package {}", (Object)applicationPackage);
            this.listeners.forEach(l -> l.onUnregister(applicationPackage));
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected abstract IAlgorithm createAlgorithm(ApplicationPackage var1);

    protected abstract TypedProcessDescription createProcessDescription(ApplicationPackage var1);
}

