/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.transactional;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.n52.faroe.ConfigurationError;
import org.n52.javaps.transactional.InitialTransactionalAlgorithmProvider;
import org.n52.javaps.transactional.UndeletableApplicationPackage;
import org.n52.shetland.ogc.wps.ap.ApplicationPackage;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.DecoderRepository;
import org.n52.svalbard.decode.JsonDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ResourceAlgorithmProvider
implements InitialTransactionalAlgorithmProvider {
    private final ResourceLoader resourceLoader;
    private final DecoderRepository decoderRepository;
    private final String location;
    private final ObjectReader objectReader;
    private boolean deletable;

    public ResourceAlgorithmProvider(ResourceLoader resourceLoader, DecoderRepository decoderRepository, ObjectReader objectReader, String location, boolean deletable) {
        this.resourceLoader = Objects.requireNonNull(resourceLoader);
        this.decoderRepository = Objects.requireNonNull(decoderRepository);
        this.location = Objects.requireNonNull(location);
        this.objectReader = Objects.requireNonNull(objectReader);
        this.deletable = deletable;
    }

    @Override
    public ApplicationPackage get() {
        ApplicationPackage applicationPackage;
        Decoder decoder = (Decoder)this.decoderRepository.tryGetDecoder((DecoderKey)new JsonDecoderKey(ApplicationPackage.class), new DecoderKey[0]).orElseThrow(() -> new ConfigurationError("No application package decoder found", new Object[0]));
        Resource resource = this.resourceLoader.getResource(this.location);
        if (!resource.isReadable()) {
            throw new ConfigurationError("Resource location %s is not readable", new Object[]{this.location});
        }
        try (InputStream inputStream = resource.getInputStream();){
            applicationPackage = (ApplicationPackage)decoder.decode((Object)this.objectReader.readTree(inputStream));
        }
        catch (IOException | DecodingException e) {
            throw new ConfigurationError(String.format("Cannot read resource %s", this.location), e);
        }
        if (!this.deletable) {
            applicationPackage = new UndeletableApplicationPackage(applicationPackage);
        }
        return applicationPackage;
    }
}

