/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.transactional;

import com.fasterxml.jackson.databind.ObjectReader;
import java.util.Objects;
import org.n52.javaps.transactional.ResourceAlgorithmProvider;
import org.n52.svalbard.decode.DecoderRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class ResourceAlgorithmProviderFactory {
    private final DecoderRepository decoderRepository;
    private final ObjectReader objectReader;
    private final ResourceLoader resourceLoader;

    @Autowired
    public ResourceAlgorithmProviderFactory(DecoderRepository decoderRepository, ObjectReader objectReader, ResourceLoader resourceLoader) {
        this.decoderRepository = Objects.requireNonNull(decoderRepository);
        this.objectReader = Objects.requireNonNull(objectReader);
        this.resourceLoader = Objects.requireNonNull(resourceLoader);
    }

    public ResourceAlgorithmProvider create(String resource, boolean deletable) {
        return new ResourceAlgorithmProvider(this.resourceLoader, this.decoderRepository, this.objectReader, resource, deletable);
    }
}

