/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.transactional;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.janmayen.lifecycle.Destroyable;
import org.n52.javaps.engine.Engine;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.javaps.transactional.DuplicateProcessException;
import org.n52.javaps.transactional.InitialTransactionalAlgorithmProvider;
import org.n52.javaps.transactional.ListenableTransactionalAlgorithmRepository;
import org.n52.javaps.transactional.ResourceAlgorithmProviderFactory;
import org.n52.javaps.transactional.TransactionalAlgorithmConfiguration;
import org.n52.javaps.transactional.TransactionalAlgorithmConfigurer;
import org.n52.javaps.transactional.TransactionalAlgorithmRegistry;
import org.n52.javaps.transactional.TransactionalAlgorithmRepository;
import org.n52.javaps.transactional.TransactionalAlgorithmRepositoryListener;
import org.n52.javaps.transactional.UndeletableProcessException;
import org.n52.javaps.transactional.UnsupportedProcessException;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.ap.ApplicationPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionalAlgorithmRegistryImpl
implements TransactionalAlgorithmConfiguration,
TransactionalAlgorithmRegistry,
Constructable,
Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalAlgorithmRegistryImpl.class);
    private final Engine engine;
    private final ResourceAlgorithmProviderFactory resourceAlgorithmProviderFactory;
    private final Set<InitialTransactionalAlgorithmProvider> providers = new HashSet<InitialTransactionalAlgorithmProvider>();
    private final Set<TransactionalAlgorithmRepositoryListener> listeners = new HashSet<TransactionalAlgorithmRepositoryListener>();
    private Set<TransactionalAlgorithmRepository> repositories = Collections.emptySet();
    private Set<TransactionalAlgorithmConfigurer> configurers = Collections.emptySet();

    @Autowired
    public TransactionalAlgorithmRegistryImpl(Engine engine, ResourceAlgorithmProviderFactory resourceAlgorithmProviderFactory) {
        this.engine = Objects.requireNonNull(engine);
        this.resourceAlgorithmProviderFactory = Objects.requireNonNull(resourceAlgorithmProviderFactory);
    }

    @Autowired(required=false)
    public void setListeners(Set<TransactionalAlgorithmRepositoryListener> listeners) {
        Optional.ofNullable(listeners).ifPresent(this.listeners::addAll);
    }

    @Autowired(required=false)
    public void setRepositories(Set<TransactionalAlgorithmRepository> repositories) {
        this.repositories = Optional.ofNullable(repositories).orElseGet(Collections::emptySet);
    }

    @Autowired(required=false)
    public void setConfigurers(Set<TransactionalAlgorithmConfigurer> configurers) {
        this.configurers = Optional.ofNullable(configurers).orElseGet(Collections::emptySet);
    }

    @Override
    public TransactionalAlgorithmConfiguration addAlgorithmFromResource(String resource, boolean deletable) {
        this.providers.add(this.resourceAlgorithmProviderFactory.create(resource, deletable));
        return this;
    }

    @Override
    public TransactionalAlgorithmConfiguration addListener(TransactionalAlgorithmRepositoryListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
        return this;
    }

    public void init() {
        this.configurers.forEach(configurer -> configurer.configure(this));
        this.repositories.stream().filter(ListenableTransactionalAlgorithmRepository.class::isInstance).map(ListenableTransactionalAlgorithmRepository.class::cast).forEach(repository -> this.listeners.forEach(repository::addListener));
        for (InitialTransactionalAlgorithmProvider provider : this.providers) {
            ApplicationPackage applicationPackage = (ApplicationPackage)provider.get();
            try {
                OwsCode id = this.register(applicationPackage);
                LOG.info("Registered application package {}", (Object)id);
            }
            catch (DuplicateProcessException e) {
                LOG.warn("Duplicate application package: " + applicationPackage, (Throwable)((Object)e));
            }
            catch (UnsupportedProcessException e) {
                LOG.error("Unsupported application package: " + applicationPackage, (Throwable)((Object)e));
            }
        }
    }

    public void destroy() {
        this.repositories.stream().filter(ListenableTransactionalAlgorithmRepository.class::isInstance).map(ListenableTransactionalAlgorithmRepository.class::cast).forEach(repository -> this.listeners.forEach(repository::removeListener));
    }

    @Override
    public void update(ApplicationPackage applicationPackage) throws UndeletableProcessException, ProcessNotFoundException, UnsupportedProcessException {
        OwsCode id = applicationPackage.getProcessDescription().getProcessDescription().getId();
        LOG.debug("updating {}", (Object)id);
        this.checkProcessExists(id);
        this.getRepository(id).unregister(id);
        try {
            this.getRepository(applicationPackage).register(applicationPackage);
        }
        catch (DuplicateProcessException e) {
            throw new RuntimeException(String.format("could not undeploy process %s", id), (Throwable)((Object)e));
        }
    }

    @Override
    public void unregister(OwsCode id) throws ProcessNotFoundException, UndeletableProcessException {
        LOG.debug("unregistering {}", (Object)id);
        this.checkProcessExists(id);
        this.getRepository(id).unregister(id);
    }

    @Override
    public OwsCode register(ApplicationPackage applicationPackage) throws DuplicateProcessException, UnsupportedProcessException {
        OwsCode id = applicationPackage.getProcessDescription().getProcessDescription().getId();
        LOG.info("registering {}", (Object)id.getValue());
        if (this.engine.getProcessDescription(id).isPresent()) {
            throw new DuplicateProcessException(id);
        }
        this.getRepository(applicationPackage).register(applicationPackage);
        return id;
    }

    private void checkProcessExists(OwsCode id) throws ProcessNotFoundException {
        this.engine.getProcessDescription(id).orElseThrow(() -> new ProcessNotFoundException(id));
    }

    private TransactionalAlgorithmRepository getRepository(OwsCode processId) throws UndeletableProcessException {
        return this.repositories.stream().filter(x -> x.containsAlgorithm(processId)).findFirst().orElseThrow(() -> new UndeletableProcessException(processId));
    }

    private TransactionalAlgorithmRepository getRepository(ApplicationPackage applicationPackage) throws UnsupportedProcessException {
        return this.repositories.stream().filter(x -> x.isSupported(applicationPackage)).findFirst().orElseThrow(UnsupportedProcessException::new);
    }
}

