/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.transactional;

import java.util.Optional;
import org.n52.javaps.algorithm.AlgorithmRepository;
import org.n52.javaps.algorithm.IAlgorithm;
import org.n52.javaps.description.TypedProcessDescription;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.javaps.transactional.DuplicateProcessException;
import org.n52.javaps.transactional.UndeletableProcessException;
import org.n52.javaps.transactional.UnsupportedProcessException;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.ap.ApplicationPackage;

public interface TransactionalAlgorithmRepository
extends AlgorithmRepository {
    default public Optional<TypedProcessDescription> getProcessDescription(OwsCode id) {
        return this.getAlgorithm(id).map(IAlgorithm::getDescription);
    }

    default public boolean containsAlgorithm(OwsCode id) {
        return this.getApplicationPackage(id).isPresent();
    }

    default public Optional<ApplicationPackage> getApplicationPackage(String id) {
        return this.getApplicationPackage(new OwsCode(id));
    }

    public Optional<ApplicationPackage> getApplicationPackage(OwsCode var1);

    public boolean isSupported(ApplicationPackage var1);

    public OwsCode register(ApplicationPackage var1) throws DuplicateProcessException, UnsupportedProcessException;

    default public void unregister(ApplicationPackage applicationPackage) throws ProcessNotFoundException, UndeletableProcessException {
        this.unregister(applicationPackage.getProcessDescription().getProcessDescription().getId());
    }

    public void unregister(OwsCode var1) throws ProcessNotFoundException, UndeletableProcessException;
}

