/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.xml;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.n52.janmayen.Optionals;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.janmayen.i18n.MultilingualString;
import org.n52.javaps.service.xml.OWSConstants;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsAnyValue;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.OwsContact;
import org.n52.shetland.ogc.ows.OwsDCP;
import org.n52.shetland.ogc.ows.OwsDomain;
import org.n52.shetland.ogc.ows.OwsDomainMetadata;
import org.n52.shetland.ogc.ows.OwsKeyword;
import org.n52.shetland.ogc.ows.OwsLanguageString;
import org.n52.shetland.ogc.ows.OwsMetadata;
import org.n52.shetland.ogc.ows.OwsNoValues;
import org.n52.shetland.ogc.ows.OwsOperation;
import org.n52.shetland.ogc.ows.OwsOperationsMetadata;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsRequestMethod;
import org.n52.shetland.ogc.ows.OwsResponsibleParty;
import org.n52.shetland.ogc.ows.OwsServiceProvider;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.ows.OwsValueRestriction;
import org.n52.shetland.ogc.ows.OwsValuesReference;
import org.n52.shetland.ogc.ows.OwsValuesUnit;
import org.n52.shetland.w3c.xlink.Link;
import org.n52.svalbard.encode.stream.xml.AbstractMultiElementXmlStreamWriter;

public abstract class AbstractOWSWriter
extends AbstractMultiElementXmlStreamWriter {
    private static final String XML_LANG = "xml:lang";

    public AbstractOWSWriter(Class<?> ... supportedClasses) {
        super((Class[])supportedClasses);
    }

    protected void writeOperationsMetadata(OwsCapabilities capabilities) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_OPERATIONS_METADATA, capabilities.getOperationsMetadata(), operationsMetadata -> {
            this.writeOperations((OwsOperationsMetadata)operationsMetadata);
            this.writeParameters(operationsMetadata.getParameters());
            this.writeConstraints(operationsMetadata.getConstraints());
        });
    }

    protected void writeKeywords(Set<OwsKeyword> set) throws XMLStreamException {
        if (!set.isEmpty()) {
            this.element(OWSConstants.Elem.QN_KEYWORDS, set, x -> {
                Map keywords = x.stream().collect(Collectors.groupingBy(OwsKeyword::getType, () -> new TreeMap(Optionals.nullsLast()), Collectors.mapping(OwsKeyword::getKeyword, Collectors.toCollection(TreeSet::new))));
                for (Map.Entry entry : keywords.entrySet()) {
                    Optional type = (Optional)entry.getKey();
                    for (OwsLanguageString keyword : (Set)entry.getValue()) {
                        this.writeLanguageString(OWSConstants.Elem.QN_KEYWORD, keyword);
                    }
                    if (!type.isPresent()) continue;
                    this.writeCode(OWSConstants.Elem.QN_TYPE, (OwsCode)type.get());
                }
            });
        }
    }

    protected void writeLanguageString(QName name, OwsLanguageString value) throws XMLStreamException {
        this.element(name, value, x -> {
            if (x.getLang().isPresent()) {
                this.attr(XML_LANG, (String)x.getLang().get());
            }
            this.chars(x.getValue());
        });
    }

    protected void writeLanguageString(QName name, Optional<OwsLanguageString> value) throws XMLStreamException {
        if (value.isPresent()) {
            this.writeLanguageString(name, value.get());
        }
    }

    protected void writeDomainMetadata(QName name, OwsDomainMetadata dmd) throws XMLStreamException {
        this.writeDomainMetadata(name, Optional.ofNullable(dmd));
    }

    protected void writeDomainMetadata(QName name, Optional<OwsDomainMetadata> metadata) throws XMLStreamException {
        if (metadata.isPresent()) {
            OwsDomainMetadata m = metadata.get();
            if (Optionals.any((Optional[])new Optional[]{m.getValue(), metadata.get().getReference()})) {
                this.element(name, m, x -> {
                    this.attr(OWSConstants.Attr.QN_REFERENCE, x.getReference().map(URI::toString));
                    if (x.getValue().isPresent()) {
                        this.chars((String)x.getValue().get());
                    }
                });
            } else {
                this.empty(name);
            }
        }
    }

    protected void writeMultilingualString(QName name, MultilingualString ms) throws XMLStreamException {
        this.forEach(name, (Iterable)ms, ls -> {
            this.langAttr(ls.getLang());
            this.chars(ls.getText());
        });
    }

    protected void langAttr(Locale lang) throws XMLStreamException {
        this.attr(XML_LANG, Optional.of(Strings.emptyToNull((String)LocaleHelper.encode((Locale)lang))));
    }

    protected void writeCode(QName name, Optional<OwsCode> id) throws XMLStreamException {
        this.element(name, id, x -> {
            this.attr("codeSpace", x.getCodeSpace().map(URI::toString));
            this.chars(x.getValue());
        });
    }

    protected void writeCode(QName name, OwsCode id) throws XMLStreamException {
        this.writeCode(name, Optional.ofNullable(id));
    }

    protected void writeHTTP(OwsDCP dcp) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_HTTP, dcp.asHTTP(), http -> {
            for (OwsRequestMethod method : http.getRequestMethods()) {
                this.writeRequestMethod(method);
            }
        });
    }

    protected void writeDCP(OwsOperation operation) throws XMLStreamException {
        this.forEach(OWSConstants.Elem.QN_DCP, operation.getDCP(), dcp -> {
            if (dcp.isHTTP()) {
                this.writeHTTP((OwsDCP)dcp);
            }
        });
    }

    protected void writeParameters(Iterable<OwsDomain> parameters) throws XMLStreamException {
        this.writeDomains(OWSConstants.Elem.QN_PARAMETER, parameters);
    }

    protected void writeLanguages(OwsCapabilities capabilities) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_LANGUAGES, capabilities.getLanguages(), languages -> this.forEach(OWSConstants.Elem.QN_LANGUAGE, (Iterable)languages, arg_0 -> ((AbstractOWSWriter)this).chars(arg_0)));
    }

    protected void writeAnyValue(OwsAnyValue anyValue) throws XMLStreamException {
        this.empty(OWSConstants.Elem.QN_ANY_VALUE);
    }

    protected void writeNoValues(OwsNoValues noValues) throws XMLStreamException {
        this.empty(OWSConstants.Elem.QN_NO_VALUES);
    }

    protected void writeValuesReference(OwsValuesReference valuesReference) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_VALUES_REFERENCE, () -> {
            this.attr("reference", valuesReference.getReference().toString());
            this.chars(valuesReference.getValue());
        });
    }

    protected void writeContactInfo(OwsResponsibleParty serviceContact) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_CONTACT_INFO, serviceContact.getContactInfo(), contactInfo -> {
            this.writePhone((OwsContact)contactInfo);
            this.writeAddress((OwsContact)contactInfo);
            this.element(OWSConstants.Elem.QN_ONLINE_RESOURCE, contactInfo.getOnlineResource(), arg_0 -> ((AbstractOWSWriter)this).writeXLinkAttrs(arg_0));
            this.element(OWSConstants.Elem.QN_HOURS_OF_SERVICE, contactInfo.getHoursOfService());
            this.element(OWSConstants.Elem.QN_CONTACT_INSTRUCTIONS, contactInfo.getContactInstructions());
        });
    }

    protected void writeAddress(OwsContact contactInfo) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_ADDRESS, contactInfo.getAddress(), address -> {
            this.forEach(OWSConstants.Elem.QN_DELIVERY_POINT, address.getDeliveryPoint(), arg_0 -> ((AbstractOWSWriter)this).chars(arg_0));
            this.element(OWSConstants.Elem.QN_CITY, address.getCity());
            this.element(OWSConstants.Elem.QN_ADMINISTRATIVE_AREA, address.getAdministrativeArea());
            this.element(OWSConstants.Elem.QN_POSTAL_CODE, address.getPostalCode());
            this.element(OWSConstants.Elem.QN_COUNTRY, address.getCountry());
            this.forEach(OWSConstants.Elem.QN_ELECTRONIC_MAIL_ADDRESS, address.getElectronicMailAddress(), arg_0 -> ((AbstractOWSWriter)this).chars(arg_0));
        });
    }

    protected void writePhone(OwsContact contactInfo) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_PHONE, contactInfo.getPhone(), phone -> {
            this.forEach(OWSConstants.Elem.QN_VOICE, phone.getVoice(), arg_0 -> ((AbstractOWSWriter)this).chars(arg_0));
            this.forEach(OWSConstants.Elem.QN_FACSIMILE, phone.getFacsimile(), arg_0 -> ((AbstractOWSWriter)this).chars(arg_0));
        });
    }

    protected void writeServiceContact(OwsServiceProvider sp) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_SERVICE_CONTACT, sp.getServiceContact(), serviceContact -> {
            this.element(OWSConstants.Elem.QN_INDIVIDUAL_NAME, serviceContact.getIndividualName());
            this.element(OWSConstants.Elem.QN_POSITION_NAME, serviceContact.getPositionName());
            this.writeContactInfo((OwsResponsibleParty)serviceContact);
            this.writeCode(OWSConstants.Elem.QN_ROLE, serviceContact.getRole());
        });
    }

    protected void writeServiceProvider(OwsCapabilities capabilities) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_SERVICE_PROVIDER, capabilities.getServiceProvider(), sp -> {
            this.element(OWSConstants.Elem.QN_PROVIDER_NAME, sp.getProviderName());
            this.element(OWSConstants.Elem.QN_PROVIDER_SITE, sp.getProviderSite(), arg_0 -> ((AbstractOWSWriter)this).writeXLinkAttrs(arg_0));
            this.writeServiceContact((OwsServiceProvider)sp);
        });
    }

    protected void writeServiceIdentification(OwsCapabilities capabilities) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_SERVICE_IDENTIFICATION, capabilities.getServiceIdentification(), si -> {
            this.writeMultilingualString(OWSConstants.Elem.QN_TITLE, si.getTitle().orElse(null));
            this.writeMultilingualString(OWSConstants.Elem.QN_ABSTRACT, si.getAbstract().orElse(null));
            this.writeKeywords(si.getKeywords());
            this.writeCode(OWSConstants.Elem.QN_SERVICE_TYPE, si.getServiceType());
            for (String version : si.getServiceTypeVersion()) {
                this.element(OWSConstants.Elem.QN_SERVICE_TYPE_VERSION, version);
            }
            for (URI profile : si.getProfiles()) {
                this.element(OWSConstants.Elem.QN_PROFILE, profile.toString());
            }
            for (String fee : si.getFees()) {
                this.element(OWSConstants.Elem.QN_FEES, fee);
            }
            for (String accessConstraints : si.getAccessConstraints()) {
                this.element(OWSConstants.Elem.QN_ACCESS_CONSTRAINTS, accessConstraints);
            }
        });
    }

    protected void writeValueRestriction(OwsValueRestriction restriction) throws XMLStreamException {
        if (restriction.isRange()) {
            this.writeRange(restriction);
        } else if (restriction.isValue()) {
            this.writeValue(restriction);
        }
    }

    protected void writeAllowedValues(OwsAllowedValues allowedValues) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_ALLOWED_VALUES, () -> {
            for (OwsValueRestriction restriction : allowedValues) {
                this.writeValueRestriction(restriction);
            }
        });
    }

    protected void writeRange(OwsValueRestriction restriction) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_RANGE, restriction.asRange(), range -> {
            this.attr("rangeClosure", range.getType());
            this.element(OWSConstants.Elem.QN_MINIMUM_VALUE, range.getLowerBound().map(OwsValue::getValue));
            this.element(OWSConstants.Elem.QN_MAXIMUM_VALUE, range.getUpperBound().map(OwsValue::getValue));
            this.element(OWSConstants.Elem.QN_SPACING, range.getSpacing().map(OwsValue::getValue));
        });
    }

    protected void writeValue(OwsValueRestriction restriction) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_VALUE, restriction.asValue().getValue());
    }

    protected void writePossibleValues(OwsPossibleValues possibleValues) throws XMLStreamException {
        if (possibleValues.isAllowedValues()) {
            this.writeAllowedValues(possibleValues.asAllowedValues());
        } else if (possibleValues.isAnyValue()) {
            this.writeAnyValue(possibleValues.asAnyValues());
        } else if (possibleValues.isNoValues()) {
            this.writeNoValues(possibleValues.asNoValues());
        } else if (possibleValues.isValuesReference()) {
            this.writeValuesReference(possibleValues.asValuesReference());
        }
    }

    protected void writeMetadata(Iterable<OwsMetadata> m) throws XMLStreamException {
        this.forEach(OWSConstants.Elem.QN_METADATA, m, metadata -> {
            this.writeXLinkAttrs((Link)metadata);
            this.attr("about", metadata.getAbout().map(URI::toString));
        });
    }

    protected void writeConstraints(Iterable<OwsDomain> constraints) throws XMLStreamException {
        this.writeDomains(OWSConstants.Elem.QN_CONSTRAINT, constraints);
    }

    protected void writeRequestMethod(OwsRequestMethod method) throws XMLStreamException {
        QName name = null;
        if (method.getHttpMethod().equals("GET")) {
            name = OWSConstants.Elem.QN_GET;
        } else if (method.getHttpMethod().equals("POST")) {
            name = OWSConstants.Elem.QN_POST;
        }
        if (name != null) {
            this.element(name, () -> {
                this.writeXLinkAttrs((Link)method);
                this.writeConstraints(method.getConstraints());
            });
        }
    }

    protected void writeOperations(OwsOperationsMetadata operationsMetadata) throws XMLStreamException {
        this.forEach(OWSConstants.Elem.QN_OPERATION, operationsMetadata.getOperations(), operation -> {
            this.attr("name", operation.getName());
            this.writeDCP((OwsOperation)operation);
            this.writeParameters(operation.getParameters());
            this.writeConstraints(operation.getConstraints());
            this.writeMetadata(operation.getMetadata());
        });
    }

    protected void writeDomains(QName name, Iterable<OwsDomain> domains) throws XMLStreamException {
        this.forEach(name, domains, domain -> {
            this.attr("name", domain.getName());
            this.writePossibleValues(domain.getPossibleValues());
            this.element(OWSConstants.Elem.QN_DEFAULT_VALUE, domain.getDefaultValue().map(OwsValue::getValue));
            this.writeDomainMetadata(OWSConstants.Elem.QN_MEANING, domain.getMeaning());
            this.writeDomainMetadata(OWSConstants.Elem.QN_DATA_TYPE, domain.getDataType());
            this.writeDomainMetadata(OWSConstants.Elem.QN_REFERENCE_SYSTEM, domain.getValuesUnit().filter(OwsValuesUnit::isReferenceSystem).map(OwsValuesUnit::asReferenceSystem));
            this.writeDomainMetadata(OWSConstants.Elem.QN_UOM, domain.getValuesUnit().filter(OwsValuesUnit::isUOM).map(OwsValuesUnit::asUOM));
            this.writeMetadata(domain.getMetadata());
        });
    }
}

