/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.xml;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.javaps.service.xml.OWSConstants;
import org.n52.shetland.ogc.ows.exception.CodedException;
import org.n52.shetland.ogc.ows.exception.ExceptionCode;
import org.n52.shetland.ogc.ows.exception.OwsExceptionCode;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.stream.OwsExceptionReportResponse;
import org.n52.svalbard.encode.stream.xml.AbstractSingleElementXmlStreamWriter;

@Configurable
public class OwsExceptionReportWriter
extends AbstractSingleElementXmlStreamWriter<OwsExceptionReportResponse> {
    private boolean includeStackTraceInExceptionReport;

    public OwsExceptionReportWriter() {
        super(OwsExceptionReportResponse.class);
    }

    @Setting(value="misc.includeStackTraceInExceptionReport")
    public void setIncludeStackTraceInExceptionReport(boolean includeStackTraceInExceptionReport) {
        this.includeStackTraceInExceptionReport = includeStackTraceInExceptionReport;
    }

    public void write(OwsExceptionReportResponse response) throws XMLStreamException {
        this.element(OWSConstants.Elem.QN_EXCEPTION_REPORT, response.getOwsExceptionReport(), report -> {
            this.namespace("ows", "http://www.opengis.net/ows/2.0");
            this.schemaLocation(Collections.singleton(new SchemaLocation("http://www.opengis.net/ows/2.0", "http://schemas.opengis.net/ows/2.0/owsAll.xsd")));
            this.attr("version", report.getVersion());
            for (CodedException exception : report.getExceptions()) {
                this.element(OWSConstants.Elem.QN_EXCEPTION, exception, x -> {
                    this.attr("locator", Optional.ofNullable(x.getLocator()));
                    this.attr("exceptionCode", Optional.ofNullable(x.getCode()).orElse((ExceptionCode)OwsExceptionCode.NoApplicableCode).toString());
                    this.element(OWSConstants.Elem.QN_EXCEPTION_TEXT, Optional.ofNullable(x.getMessage()));
                    if (this.includeStackTraceInExceptionReport) {
                        this.element(OWSConstants.Elem.QN_EXCEPTION_TEXT, x, ex -> {
                            this.chars("[EXCEPTION]: \n");
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            try {
                                ex.printStackTrace(new PrintStream((OutputStream)os, false, Charsets.UTF_8.name()));
                                this.chars(os.toString(Charsets.UTF_8.name()));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        });
                    }
                });
            }
        });
    }
}

