/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.xml;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.wps.ResponseMode;
import org.n52.shetland.ogc.wps.Result;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.response.ExecuteResponse;
import org.n52.shetland.ogc.wps.response.GetResultResponse;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.stream.MissingStreamWriterException;
import org.n52.svalbard.encode.stream.StreamWriter;
import org.n52.svalbard.encode.stream.StreamWriterKey;
import org.n52.svalbard.encode.stream.StreamWriterRepository;
import org.n52.svalbard.encode.stream.UnsupportedStreamWriterInputException;
import org.n52.svalbard.encode.stream.xml.XmlStreamWriterKey;

public class StreamingRawWriter
implements StreamWriter<OwsServiceResponse> {
    private static final Set<StreamWriterKey> KEYS = Collections.unmodifiableSet(new HashSet<StreamWriterKey>(Arrays.asList(new StreamWriterKey(ExecuteResponse.class, new MediaType()), new StreamWriterKey(GetResultResponse.class, new MediaType()))));
    private final StreamWriterRepository streamWriterRepository;

    @Inject
    public StreamingRawWriter(StreamWriterRepository streamWriterRepository) {
        this.streamWriterRepository = Objects.requireNonNull(streamWriterRepository);
    }

    public void write(OwsServiceResponse object, OutputStream outputStream) throws EncodingException {
        block21: {
            Result result = null;
            if (object instanceof GetResultResponse) {
                result = ((GetResultResponse)object).getResult();
            } else if (object instanceof ExecuteResponse) {
                result = ((ExecuteResponse)object).getResult().filter(r -> r.getResponseMode() == ResponseMode.RAW).orElseThrow(() -> new UnsupportedStreamWriterInputException((Object)object));
            } else {
                throw new UnsupportedStreamWriterInputException((Object)object);
            }
            ProcessData data = (ProcessData)result.getOutputs().iterator().next();
            if (data.isValue()) {
                try (InputStream dataStream = data.asValue().getData();){
                    ByteStreams.copy((InputStream)dataStream, (OutputStream)outputStream);
                    break block21;
                }
                catch (IOException ex) {
                    throw new EncodingException((Throwable)ex);
                }
            }
            if (data.isReference() || data.isGroup()) {
                this.getStreamWriter(data).write((Object)data, outputStream);
            } else {
                throw new UnsupportedStreamWriterInputException((Object)object);
            }
        }
    }

    private <T> StreamWriter<? super T> getStreamWriter(T data) {
        XmlStreamWriterKey key = new XmlStreamWriterKey(data.getClass());
        return (StreamWriter)this.streamWriterRepository.getWriter((StreamWriterKey)key).orElseThrow(() -> StreamingRawWriter.lambda$getStreamWriter$2((StreamWriterKey)key));
    }

    public Set<StreamWriterKey> getKeys() {
        return KEYS;
    }

    private static /* synthetic */ MissingStreamWriterException lambda$getStreamWriter$2(StreamWriterKey key) {
        return new MissingStreamWriterException(key);
    }
}

