/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.xml;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.n52.javaps.service.xml.OWSConstants;
import org.n52.javaps.service.xml.WPSConstants;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.wps.DataTransmissionMode;
import org.n52.shetland.ogc.wps.ExecutionMode;
import org.n52.shetland.ogc.wps.Format;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.OutputDefinition;
import org.n52.shetland.ogc.wps.ResponseMode;
import org.n52.shetland.ogc.wps.data.Body;
import org.n52.shetland.ogc.wps.data.GroupProcessData;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.data.ReferenceProcessData;
import org.n52.shetland.ogc.wps.data.ValueProcessData;
import org.n52.shetland.ogc.wps.data.impl.StringValueProcessData;
import org.n52.shetland.ogc.wps.request.DescribeProcessRequest;
import org.n52.shetland.ogc.wps.request.DismissRequest;
import org.n52.shetland.ogc.wps.request.ExecuteRequest;
import org.n52.shetland.ogc.wps.request.GetResultRequest;
import org.n52.shetland.ogc.wps.request.GetStatusRequest;
import org.n52.svalbard.decode.stream.StreamReaderKey;
import org.n52.svalbard.decode.stream.xml.AbstractElementXmlStreamReader;
import org.n52.svalbard.decode.stream.xml.XmlStreamReaderKey;
import org.n52.svalbard.stream.XLinkConstants;

public class WPSRequestReader
extends AbstractElementXmlStreamReader {
    private static final HashSet<XmlStreamReaderKey> KEYS = new HashSet<XmlStreamReaderKey>(Arrays.asList(new XmlStreamReaderKey(WPSConstants.Elem.QN_GET_STATUS), new XmlStreamReaderKey(WPSConstants.Elem.QN_DISMISS), new XmlStreamReaderKey(WPSConstants.Elem.QN_DESCRIBE_PROCESS), new XmlStreamReaderKey(WPSConstants.Elem.QN_EXECUTE), new XmlStreamReaderKey(WPSConstants.Elem.QN_GET_CAPABILITIES), new XmlStreamReaderKey(WPSConstants.Elem.QN_GET_RESULT)));

    public Set<StreamReaderKey> getKeys() {
        return Collections.unmodifiableSet(KEYS);
    }

    public OwsServiceRequest readElement(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement start = event.asStartElement();
            if (start.getName().equals(WPSConstants.Elem.QN_GET_STATUS)) {
                return this.readGetStatusRequest(start, reader);
            }
            if (start.getName().equals(WPSConstants.Elem.QN_DISMISS)) {
                return this.readDismissRequest(start, reader);
            }
            if (start.getName().equals(WPSConstants.Elem.QN_DESCRIBE_PROCESS)) {
                return this.readDescribeProcessRequest(start, reader);
            }
            if (start.getName().equals(WPSConstants.Elem.QN_EXECUTE)) {
                return this.readExecuteRequest(start, reader);
            }
            if (start.getName().equals(WPSConstants.Elem.QN_GET_CAPABILITIES)) {
                return this.readGetCapabilitiesRequest(start, reader);
            }
            if (start.getName().equals(WPSConstants.Elem.QN_GET_RESULT)) {
                return this.readGetResultRequest(start, reader);
            }
            throw this.unexpectedTag(start);
        }
        throw this.eof();
    }

    private GetStatusRequest readGetStatusRequest(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        GetStatusRequest request = new GetStatusRequest();
        this.readServiceAndVersion(elem, (OwsServiceRequest)request);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(WPSConstants.Elem.QN_JOB_ID)) {
                    request.setJobId(this.readJobId(start, reader));
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return request;
        }
        throw this.eof();
    }

    private JobId readJobId(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        return new JobId(reader.getElementText());
    }

    private void readServiceAndVersion(StartElement elem, OwsServiceRequest request) {
        WPSRequestReader.getAttribute((StartElement)elem, (String)"service").ifPresent(arg_0 -> ((OwsServiceRequest)request).setService(arg_0));
        WPSRequestReader.getAttribute((StartElement)elem, (String)"version").ifPresent(arg_0 -> ((OwsServiceRequest)request).setVersion(arg_0));
    }

    private DismissRequest readDismissRequest(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        DismissRequest request = new DismissRequest();
        this.readServiceAndVersion(elem, (OwsServiceRequest)request);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(WPSConstants.Elem.QN_JOB_ID)) {
                    request.setJobId(this.readJobId(start, reader));
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return request;
        }
        throw this.eof();
    }

    private DescribeProcessRequest readDescribeProcessRequest(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        DescribeProcessRequest request = new DescribeProcessRequest();
        this.readServiceAndVersion(elem, (OwsServiceRequest)request);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(OWSConstants.Elem.QN_IDENTIFIER)) {
                    OwsCode identifier = null;
                    try {
                        identifier = this.readIdentifier(start, reader);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (identifier == null) continue;
                    request.addProcessIdentifier(identifier);
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return request;
        }
        throw this.eof();
    }

    private GetResultRequest readGetResultRequest(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        GetResultRequest request = new GetResultRequest();
        this.readServiceAndVersion(elem, (OwsServiceRequest)request);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(WPSConstants.Elem.QN_JOB_ID)) {
                    request.setJobId(this.readJobId(start, reader));
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return request;
        }
        throw this.eof();
    }

    private ExecuteRequest readExecuteRequest(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        ExecuteRequest request = new ExecuteRequest();
        this.readServiceAndVersion(elem, (OwsServiceRequest)request);
        WPSRequestReader.getAttribute((StartElement)elem, (String)"mode").flatMap(ExecutionMode::fromString).ifPresent(arg_0 -> ((ExecuteRequest)request).setExecutionMode(arg_0));
        WPSRequestReader.getAttribute((StartElement)elem, (String)"response").flatMap(ResponseMode::fromString).ifPresent(arg_0 -> ((ExecuteRequest)request).setResponseMode(arg_0));
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(OWSConstants.Elem.QN_IDENTIFIER)) {
                    request.setId(this.readIdentifier(start, reader));
                    continue;
                }
                if (start.getName().equals(WPSConstants.Elem.QN_INPUT)) {
                    request.addInput(this.readInput(start, reader));
                    continue;
                }
                if (start.getName().equals(WPSConstants.Elem.QN_OUTPUT)) {
                    request.addOutput(this.readOutput(start, reader));
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return request;
        }
        throw this.eof();
    }

    private GetCapabilitiesRequest readGetCapabilitiesRequest(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        String service = WPSRequestReader.getAttribute((StartElement)elem, (String)"service").orElse(null);
        GetCapabilitiesRequest request = new GetCapabilitiesRequest(service);
        WPSRequestReader.getAttribute((StartElement)elem, (String)"updateSequence").ifPresent(arg_0 -> ((GetCapabilitiesRequest)request).setUpdateSequence(arg_0));
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(OWSConstants.Elem.QN_ACCEPT_VERSIONS)) {
                    request.setAcceptVersions(this.readAcceptVersions(start, reader));
                    continue;
                }
                if (start.getName().equals(OWSConstants.Elem.QN_SECTIONS)) {
                    request.setSections(this.readSections(start, reader));
                    continue;
                }
                if (start.getName().equals(OWSConstants.Elem.QN_ACCEPT_FORMATS)) {
                    request.setAcceptFormats(this.readAcceptFormats(start, reader));
                    continue;
                }
                if (start.getName().equals(OWSConstants.Elem.QN_ACCEPT_LANGUAGES)) {
                    request.setAcceptLanguages(this.readAcceptLanguages(start, reader));
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return request;
        }
        throw this.eof();
    }

    private OwsCode readIdentifier(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        return this.readOwsCode(elem, reader);
    }

    private OwsCode readOwsCode(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        URI codeSpace = WPSRequestReader.getAttribute((StartElement)elem, (String)"codeSpace").map(URI::create).orElse(null);
        return new OwsCode(reader.getElementText(), codeSpace);
    }

    private List<String> readAcceptVersions(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        LinkedList<String> list = new LinkedList<String>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(OWSConstants.Elem.QN_VERSION)) {
                    list.add(reader.getElementText());
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return list;
        }
        throw this.eof();
    }

    private List<String> readSections(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        LinkedList<String> list = new LinkedList<String>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(OWSConstants.Elem.QN_SECTION)) {
                    list.add(reader.getElementText());
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return list;
        }
        throw this.eof();
    }

    private List<String> readAcceptFormats(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        LinkedList<String> list = new LinkedList<String>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(OWSConstants.Elem.QN_OUTPUT_FORMAT)) {
                    list.add(reader.getElementText());
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return list;
        }
        throw this.eof();
    }

    private List<String> readAcceptLanguages(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        LinkedList<String> list = new LinkedList<String>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(OWSConstants.Elem.QN_LANGUAGE)) {
                    list.add(reader.getElementText());
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return list;
        }
        throw this.eof();
    }

    private OutputDefinition readOutput(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        OutputDefinition outputDefinition = new OutputDefinition();
        Optional attribute = WPSRequestReader.getAttribute((StartElement)elem, (String)"transmission");
        Optional flatMap = attribute.flatMap(DataTransmissionMode::fromString);
        flatMap.ifPresent(arg_0 -> ((OutputDefinition)outputDefinition).setDataTransmissionMode(arg_0));
        WPSRequestReader.getAttribute((StartElement)elem, (String)"id").map(OwsCode::new).ifPresent(arg_0 -> ((OutputDefinition)outputDefinition).setId(arg_0));
        outputDefinition.setFormat(this.readFormat(elem));
        LinkedList<OutputDefinition> outputs = new LinkedList<OutputDefinition>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(WPSConstants.Elem.QN_OUTPUT)) {
                    outputs.add(this.readOutput(start, reader));
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            outputDefinition.setOutputs(outputs);
            return outputDefinition;
        }
        throw this.eof();
    }

    private Format readFormat(StartElement elem) {
        String mimeType = WPSRequestReader.getAttribute((StartElement)elem, (String)"mimeType").orElse(null);
        String encoding = WPSRequestReader.getAttribute((StartElement)elem, (String)"encoding").orElse(null);
        String schema = WPSRequestReader.getAttribute((StartElement)elem, (String)"schema").orElse(null);
        return new Format(mimeType, encoding, schema);
    }

    private ProcessData readInput(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        OwsCode id = WPSRequestReader.getAttribute((StartElement)elem, (String)"id").map(OwsCode::new).orElse(null);
        LinkedList<ProcessData> inputs = new LinkedList<ProcessData>();
        ValueProcessData data = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(WPSConstants.Elem.QN_DATA)) {
                    data = this.readData(start, reader, id);
                    continue;
                }
                if (start.getName().equals(WPSConstants.Elem.QN_REFERENCE)) {
                    data = this.readReference(start, reader, id);
                    continue;
                }
                if (start.getName().equals(WPSConstants.Elem.QN_INPUT)) {
                    inputs.add(this.readInput(start, reader));
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            if (data == null) {
                if (inputs.isEmpty()) {
                    throw new IllegalStateException();
                }
                data = new GroupProcessData(id, inputs);
            }
            return data;
        }
        throw this.eof();
    }

    private ReferenceProcessData readReference(StartElement elem, XMLEventReader reader, OwsCode id) throws XMLStreamException {
        ReferenceProcessData data = new ReferenceProcessData(id);
        data.setFormat(this.readFormat(elem));
        data.setURI((URI)WPSRequestReader.getAttribute((StartElement)elem, (QName)XLinkConstants.Attr.QN_HREF).map(URI::create).orElse(null));
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(WPSConstants.Elem.QN_BODY)) {
                    data.setBody(this.parseBody(start, reader));
                    continue;
                }
                if (start.getName().equals(WPSConstants.Elem.QN_BODY_REFERENCE)) {
                    data.setBody(this.parseBodyReference(start, reader));
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return data;
        }
        throw this.eof();
    }

    private Body parseBodyReference(StartElement elem, XMLEventReader reader) throws XMLStreamException {
        URI href = WPSRequestReader.getAttribute((StartElement)elem, (QName)XLinkConstants.Attr.QN_HREF).map(URI::create).orElse(null);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                throw this.unexpectedTag(event.asStartElement());
            }
            if (!event.isEndElement()) continue;
            return Body.reference((URI)href);
        }
        throw this.eof();
    }

    private Body parseBody(StartElement start, XMLEventReader reader) throws XMLStreamException {
        return Body.inline((String)this.asString(start, reader));
    }

    private ValueProcessData readData(StartElement start, XMLEventReader reader, OwsCode id) throws XMLStreamException {
        Format format = this.readFormat(start);
        String string = this.asString(start, reader);
        return new StringValueProcessData(id, format, string);
    }
}

