/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.xml;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64InputStream;
import org.n52.javaps.io.bbox.BoundingBoxInputOutputHandler;
import org.n52.javaps.io.literal.LiteralInputOutputHandler;
import org.n52.javaps.service.xml.AbstractOWSWriter;
import org.n52.javaps.service.xml.OWSConstants;
import org.n52.javaps.service.xml.WPSConstants;
import org.n52.shetland.ogc.ows.OwsCRS;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.wps.DataTransmissionMode;
import org.n52.shetland.ogc.wps.Format;
import org.n52.shetland.ogc.wps.JobControlOption;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.ProcessOffering;
import org.n52.shetland.ogc.wps.ProcessOfferings;
import org.n52.shetland.ogc.wps.ResponseMode;
import org.n52.shetland.ogc.wps.Result;
import org.n52.shetland.ogc.wps.StatusInfo;
import org.n52.shetland.ogc.wps.WPSCapabilities;
import org.n52.shetland.ogc.wps.data.Body;
import org.n52.shetland.ogc.wps.data.GroupProcessData;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.data.ReferenceProcessData;
import org.n52.shetland.ogc.wps.data.ValueProcessData;
import org.n52.shetland.ogc.wps.description.BoundingBoxDescription;
import org.n52.shetland.ogc.wps.description.BoundingBoxInputDescription;
import org.n52.shetland.ogc.wps.description.BoundingBoxOutputDescription;
import org.n52.shetland.ogc.wps.description.ComplexDescription;
import org.n52.shetland.ogc.wps.description.ComplexInputDescription;
import org.n52.shetland.ogc.wps.description.ComplexOutputDescription;
import org.n52.shetland.ogc.wps.description.Description;
import org.n52.shetland.ogc.wps.description.GroupInputDescription;
import org.n52.shetland.ogc.wps.description.GroupOutputDescription;
import org.n52.shetland.ogc.wps.description.LiteralDataDomain;
import org.n52.shetland.ogc.wps.description.LiteralDescription;
import org.n52.shetland.ogc.wps.description.LiteralInputDescription;
import org.n52.shetland.ogc.wps.description.LiteralOutputDescription;
import org.n52.shetland.ogc.wps.description.ProcessDescription;
import org.n52.shetland.ogc.wps.description.ProcessInputDescription;
import org.n52.shetland.ogc.wps.description.ProcessInputDescriptionContainer;
import org.n52.shetland.ogc.wps.description.ProcessOutputDescription;
import org.n52.shetland.ogc.wps.description.ProcessOutputDescriptionContainer;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.stream.XLinkConstants;

public class WPSWriter
extends AbstractOWSWriter {
    private static final String UNBOUNDED = "unbounded";
    private static final String TRUE = "true";
    private final ConcreteOutputWriter concreteOutputWriter = new ConcreteOutputWriter();
    private final ConcreteInputWriter concreteInputWriter = new ConcreteInputWriter();

    public WPSWriter() {
        super(ProcessOfferings.class, Result.class, StatusInfo.class, ProcessDescription.class, WPSCapabilities.class, ProcessData.class);
    }

    public void writeElement(Object object) throws XMLStreamException, EncodingException {
        if (object instanceof ProcessOffering) {
            this.writeProcessOffering((ProcessOffering)object);
        } else if (object instanceof Result) {
            this.writeResult((Result)object);
        } else if (object instanceof StatusInfo) {
            this.writeStatusInfo((StatusInfo)object);
        } else if (object instanceof ProcessData) {
            this.writeOutput((ProcessData)object);
        } else if (object instanceof ProcessDescription) {
            this.writeProcessDescription((ProcessDescription)object);
        } else if (object instanceof WPSCapabilities) {
            this.writeWPSCapabilities((WPSCapabilities)object);
        } else if (object instanceof ProcessOfferings) {
            this.writeProcessOfferings((ProcessOfferings)object);
        } else {
            throw this.unsupported(object);
        }
    }

    private void writeWPSCapabilities(WPSCapabilities object) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_CAPABILITIES, object, capabilities -> {
            this.writeNamespacesWithSchemalocation();
            this.attr("service", capabilities.getService());
            this.attr("version", capabilities.getVersion());
            this.attr("updateSequence", capabilities.getUpdateSequence());
            this.writeServiceIdentification((OwsCapabilities)capabilities);
            this.writeServiceProvider((OwsCapabilities)capabilities);
            this.writeOperationsMetadata((OwsCapabilities)capabilities);
            this.writeLanguages((OwsCapabilities)capabilities);
            this.writeContents((WPSCapabilities)capabilities);
        });
    }

    private void writeContents(WPSCapabilities capabilities) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_CONTENTS, capabilities.getProcessOfferings(), offerings -> this.forEach(WPSConstants.Elem.QN_PROCESS_SUMMARY, (Iterable)offerings, offering -> {
            this.attr("jobControlOptions", offering.getJobControlOptions(), JobControlOption::getValue);
            this.attr("outputTransmission", offering.getOutputTransmissionModes(), DataTransmissionMode::getValue);
            this.attr("processVersion", offering.getProcessVersion());
            this.attr("processModel", offering.getProcessModel());
            this.writeDescriptionElements((Description)offering.getProcessDescription());
        }));
    }

    private void writeProcessInputDescription(ProcessInputDescription input) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_INPUT, input, x -> {
            this.attr("minOccurs", x.getOccurence().getMin().toString());
            this.attr("maxOccurs", x.getOccurence().getMax().map(Object::toString).orElse(UNBOUNDED));
            this.writeDescriptionElements((Description)x);
            x.visit((ProcessInputDescription.ThrowingVisitor)this.concreteInputWriter);
        });
    }

    private void writeProcessOutputDescription(ProcessOutputDescription output) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_OUTPUT, () -> {
            this.writeDescriptionElements((Description)output);
            output.visit((ProcessOutputDescription.ThrowingVisitor)this.concreteOutputWriter);
        });
    }

    private void writeDescriptionElements(Description description) throws XMLStreamException {
        this.writeLanguageString(OWSConstants.Elem.QN_TITLE, description.getTitle());
        this.writeLanguageString(OWSConstants.Elem.QN_ABSTRACT, description.getAbstract());
        this.writeKeywords(description.getKeywords());
        this.writeCode(OWSConstants.Elem.QN_IDENTIFIER, description.getId());
        this.writeMetadata(description.getMetadata());
    }

    private void writeFormat(Format format, Optional<BigInteger> maximumMegabytes, boolean isDefaultFormat) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_FORMAT, () -> {
            this.writeDataEncodingAttributes(format);
            this.attr("maximumMegabytes", maximumMegabytes.map(BigInteger::toString));
            if (isDefaultFormat) {
                this.attr("default", TRUE);
            }
        });
    }

    private void writeLiteralDataDomain(LiteralDataDomain literalDataDomain, boolean defaultDomain) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_LITERAL_DATA_DOMAIN, literalDataDomain, ldd -> {
            OwsPossibleValues vd;
            if (defaultDomain) {
                this.attr("default", TRUE);
            }
            if ((vd = ldd.getPossibleValues()).isAnyValue()) {
                this.writeAnyValue(vd.asAnyValues());
            } else if (vd.isAllowedValues()) {
                this.writeAllowedValues(vd.asAllowedValues());
            } else if (vd.isValuesReference()) {
                this.writeValuesReference(vd.asValuesReference());
            }
            this.writeDomainMetadata(OWSConstants.Elem.QN_DATA_TYPE, ldd.getDataType());
            this.writeDomainMetadata(OWSConstants.Elem.QN_UOM, ldd.getUOM());
            this.element(OWSConstants.Elem.QN_DEFAULT_VALUE, ldd.getDefaultValue().map(OwsValue::getValue));
        });
    }

    private void writeBoundingBoxDescription(BoundingBoxDescription input) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_BOUNDING_BOX_DATA, input, x -> {
            this.writeFormats(BoundingBoxInputOutputHandler.FORMATS);
            this.element(WPSConstants.Elem.QN_SUPPORTED_CRS, x.getDefaultCRS(), crs -> {
                this.attr("default", TRUE);
                this.chars(crs.getValue().toString());
            });
            for (OwsCRS crs2 : x.getSupportedCRS()) {
                this.element(WPSConstants.Elem.QN_SUPPORTED_CRS, crs2.getValue().toString());
            }
        });
    }

    private void writeComplexDescription(ComplexDescription input) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_COMPLEX_DATA, input, x -> this.writeFormats((ComplexDescription)x));
    }

    private void writeLiteralDescription(LiteralDescription input) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_LITERAL_DATA, input, x -> {
            this.writeFormats(LiteralInputOutputHandler.FORMATS);
            this.writeLiteralDataDomain(x.getDefaultLiteralDataDomain(), true);
            for (LiteralDataDomain ldd : x.getSupportedLiteralDataDomains()) {
                this.writeLiteralDataDomain(ldd, false);
            }
        });
    }

    private void writeProcessInputDescriptionContainer(ProcessInputDescriptionContainer container) throws XMLStreamException {
        for (ProcessInputDescription description : container.getInputDescriptions()) {
            this.writeProcessInputDescription(description);
        }
    }

    private void writeProcessOutputDescriptionContainer(ProcessOutputDescriptionContainer container) throws XMLStreamException {
        for (ProcessOutputDescription description : container.getOutputDescriptions()) {
            this.writeProcessOutputDescription(description);
        }
    }

    private void writeProcessDescription(ProcessDescription object) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_PROCESS, object, x -> {
            this.writeNamespacesWithSchemalocation();
            this.writeDescriptionElements((Description)object);
            this.writeProcessInputDescriptionContainer((ProcessInputDescriptionContainer)object);
            this.writeProcessOutputDescriptionContainer((ProcessOutputDescriptionContainer)object);
        });
    }

    private void writeReferenceData(ReferenceProcessData reference) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_REFERENCE, () -> {
            this.writeNamespaces();
            this.attr(XLinkConstants.Attr.QN_HREF, reference.getURI().toString());
            this.writeDataEncodingAttributes(reference.getFormat());
            if (reference.getBody().isPresent()) {
                Body body = (Body)reference.getBody().get();
                if (body.isInline()) {
                    this.element(WPSConstants.Elem.QN_BODY, body.asInline(), b -> this.cdata(b.getBody()));
                } else if (body.isReferenced()) {
                    this.element(WPSConstants.Elem.QN_BODY_REFERENCE, body.asReferenced(), b -> this.attr(XLinkConstants.Attr.QN_HREF, b.getHref().toString()));
                } else {
                    throw new AssertionError();
                }
            }
        });
    }

    private void writeStatusInfo(StatusInfo object) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_STATUS_INFO, () -> {
            this.writeNamespacesWithSchemalocation();
            this.element(WPSConstants.Elem.QN_JOB_ID, object.getJobId().getValue());
            this.element(WPSConstants.Elem.QN_STATUS, object.getStatus().getValue());
            this.element(WPSConstants.Elem.QN_EXPIRATION_DATE, object.getExpirationDate().map(arg_0 -> ((WPSWriter)this).format(arg_0)));
            this.element(WPSConstants.Elem.QN_ESTIMATED_COMPLETION, object.getEstimatedCompletion().map(arg_0 -> ((WPSWriter)this).format(arg_0)));
            this.element(WPSConstants.Elem.QN_NEXT_POLL, object.getNextPoll().map(arg_0 -> ((WPSWriter)this).format(arg_0)));
            this.element(WPSConstants.Elem.QN_PERCENT_COMPLETED, object.getPercentCompleted().map(String::valueOf));
        });
    }

    private void writeDataEncodingAttributes(Format format) throws XMLStreamException {
        this.attr("mimeType", format.getMimeType());
        this.attr("encoding", format.getEncoding());
        this.attr("schema", format.getSchema());
    }

    private void writeValueData(ValueProcessData value) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_DATA, value, x -> {
            block42: {
                this.writeNamespaces();
                Format format = x.getFormat();
                try (InputStream data = x.getData();){
                    if (!x.getFormat().hasEncoding() || x.getFormat().isCharacterEncoding()) {
                        this.writeDataEncodingAttributes(format.withEncoding(this.documentEncoding()));
                        Charset charset = format.getEncodingAsCharsetOrDefault();
                        try (InputStreamReader reader = new InputStreamReader(data, charset);){
                            if (format.isXML()) {
                                this.write(reader);
                            } else {
                                this.cdata(CharStreams.toString((Readable)reader));
                            }
                            break block42;
                        }
                    }
                    this.writeDataEncodingAttributes(format.withBase64Encoding());
                    if (format.isBase64()) {
                        try (Base64InputStream in = new Base64InputStream(data, false);){
                            this.writeBase64((InputStream)in);
                            break block42;
                        }
                    }
                    this.writeBase64(data);
                }
                catch (IOException ex) {
                    throw new XMLStreamException(ex);
                }
            }
        });
    }

    private void writeResult(Result result) throws XMLStreamException {
        if (result.getResponseMode() == ResponseMode.RAW) {
            this.writeRawResult(result);
        } else {
            this.element(WPSConstants.Elem.QN_RESULT, result, x -> {
                this.writeNamespacesWithSchemalocation();
                this.element(WPSConstants.Elem.QN_JOB_ID, x.getJobId().map(JobId::getValue));
                this.element(WPSConstants.Elem.QN_EXPIRATION_DATE, x.getExpirationDate().map(arg_0 -> ((WPSWriter)this).format(arg_0)));
                for (ProcessData data : x.getOutputs()) {
                    this.writeOutput(data);
                }
            });
        }
    }

    private void writeOutput(ProcessData data) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_OUTPUT, data, x -> {
            this.writeNamespaces();
            this.attr("id", x.getId().getValue());
            this.attr("codeSpace", x.getId().getCodeSpace().map(URI::toString));
            if (x.isGroup()) {
                this.writeGroupData(x.asGroup());
            } else if (x.isReference()) {
                this.writeReferenceData(x.asReference());
            } else if (x.isValue()) {
                this.writeValueData(x.asValue());
            }
        });
    }

    private void writeProcessOffering(ProcessOffering offering) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_PROCESS_OFFERING, offering, x -> {
            this.attr("jobControlOptions", x.getJobControlOptions(), JobControlOption::getValue);
            this.attr("outputTransmission", x.getOutputTransmissionModes(), DataTransmissionMode::getValue);
            this.attr("processVersion", x.getProcessVersion());
            this.attr("processModel", x.getProcessModel());
            this.writeProcessDescription(offering.getProcessDescription());
        });
    }

    private void writeNamespaces() throws XMLStreamException {
        this.namespace("wps", "http://www.opengis.net/wps/2.0");
        this.namespace("ows", "http://www.opengis.net/ows/2.0");
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
    }

    private void writeNamespacesWithSchemalocation() throws XMLStreamException {
        this.writeNamespaces();
        this.schemaLocation(Collections.singleton(new SchemaLocation("http://www.opengis.net/wps/2.0", "http://schemas.opengis.net/wps/2.0/wps.xsd")));
    }

    private void writeGroupData(GroupProcessData x) throws XMLStreamException {
        for (ProcessData output : x.getElements()) {
            this.writeOutput(output);
        }
    }

    private void writeProcessOfferings(ProcessOfferings offerings) throws XMLStreamException {
        this.element(WPSConstants.Elem.QN_PROCESS_OFFERINGS, () -> {
            this.writeNamespacesWithSchemalocation();
            for (ProcessOffering processOffering : offerings) {
                this.writeProcessOffering(processOffering);
            }
        });
    }

    private void writeFormats(ComplexDescription x) throws XMLStreamException {
        this.writeFormat(x.getDefaultFormat(), x.getMaximumMegabytes(), true);
        for (Format format : x.getSupportedFormats()) {
            this.writeFormat(format, x.getMaximumMegabytes(), false);
        }
    }

    private void writeFormats(Set<Format> formats) throws XMLStreamException {
        Iterator<Format> iter = formats.iterator();
        if (iter.hasNext()) {
            this.writeFormat(iter.next(), Optional.empty(), true);
            while (iter.hasNext()) {
                this.writeFormat(iter.next(), Optional.empty(), false);
            }
        }
    }

    private void writeRawResult(Result result) throws XMLStreamException {
        ProcessData output = (ProcessData)result.getOutputs().iterator().next();
        if (output.isGroup() || output.isReference()) {
            this.writeOutput(output);
        } else {
            Charset charset = output.asValue().getFormat().getEncodingAsCharsetOrDefault();
            try (InputStream in = output.asValue().getData();
                 InputStreamReader reader = new InputStreamReader(in, charset);){
                this.write(reader);
            }
            catch (IOException ex) {
                throw new XMLStreamException(ex);
            }
        }
    }

    private class ConcreteOutputWriter
    implements ProcessOutputDescription.ThrowingVisitor<XMLStreamException> {
        private ConcreteOutputWriter() {
        }

        public void visit(BoundingBoxOutputDescription output) throws XMLStreamException {
            WPSWriter.this.writeBoundingBoxDescription((BoundingBoxDescription)output);
        }

        public void visit(ComplexOutputDescription output) throws XMLStreamException {
            WPSWriter.this.writeComplexDescription((ComplexDescription)output);
        }

        public void visit(LiteralOutputDescription output) throws XMLStreamException {
            WPSWriter.this.writeLiteralDescription((LiteralDescription)output);
        }

        public void visit(GroupOutputDescription output) throws XMLStreamException {
            WPSWriter.this.writeProcessOutputDescriptionContainer((ProcessOutputDescriptionContainer)output);
        }
    }

    private class ConcreteInputWriter
    implements ProcessInputDescription.ThrowingVisitor<XMLStreamException> {
        private ConcreteInputWriter() {
        }

        public void visit(BoundingBoxInputDescription input) throws XMLStreamException {
            WPSWriter.this.writeBoundingBoxDescription((BoundingBoxDescription)input);
        }

        public void visit(ComplexInputDescription input) throws XMLStreamException {
            WPSWriter.this.writeComplexDescription((ComplexDescription)input);
        }

        public void visit(LiteralInputDescription input) throws XMLStreamException {
            WPSWriter.this.writeLiteralDescription((LiteralDescription)input);
        }

        public void visit(GroupInputDescription input) throws XMLStreamException {
            WPSWriter.this.writeProcessInputDescriptionContainer((ProcessInputDescriptionContainer)input);
        }
    }
}

