/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.control;

import com.google.common.io.Resources;
import java.net.URL;
import java.util.Collections;
import org.n52.youngs.api.Report;
import org.n52.youngs.control.impl.SingleThreadBulkRunner;
import org.n52.youngs.harvest.KvpCswSource;
import org.n52.youngs.impl.NamespaceContextImpl;
import org.n52.youngs.impl.XPathHelper;
import org.n52.youngs.load.impl.ElasticsearchRemoteHttpSink;
import org.n52.youngs.transform.impl.CswToBuilderMapper;
import org.n52.youngs.transform.impl.YamlMappingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws Exception {
        Report report = Main.dabGmd();
        log.info("Done:\n{}", (Object)report);
    }

    public static Report dabGmd() throws Exception {
        KvpCswSource source = new KvpCswSource("http://api.eurogeoss-broker.eu/dab/services/cswiso", Collections.singleton("http://www.isotc211.org/2005/gmd"), NamespaceContextImpl.create(), "gmd:MD_Metadata", "http://www.isotc211.org/2005/gmd");
        YamlMappingConfiguration configuration = new YamlMappingConfiguration(Resources.asByteSource((URL)Resources.getResource((String)"mappings/gmd-metadata.yml")).openStream(), new XPathHelper());
        CswToBuilderMapper mapper = new CswToBuilderMapper(configuration);
        String host = "localhost";
        String cluster = "ConnectinGEO";
        String index = "geodab";
        String type = "isorecord";
        int port = 9301;
        ElasticsearchRemoteHttpSink sink = new ElasticsearchRemoteHttpSink(host, port, cluster, index, type);
        SingleThreadBulkRunner runner = new SingleThreadBulkRunner().setBulkSize(10L).setRecordsLimit(10000L).setStartPosition(10000L).harvest(source).transform(mapper);
        Report report = runner.load(sink);
        return report;
    }

    public static Report dabCsw() throws Exception {
        KvpCswSource source = new KvpCswSource("http://api.eurogeoss-broker.eu/dab/services/cswiso", Collections.singleton("http://www.opengis.net/cat/csw/2.0.2"), NamespaceContextImpl.create(), "csw:Record", "http://www.opengis.net/cat/csw/2.0.2");
        YamlMappingConfiguration configuration = new YamlMappingConfiguration(Resources.asByteSource((URL)Resources.getResource((String)"mappings/csw-record.yml")).openStream(), new XPathHelper());
        CswToBuilderMapper mapper = new CswToBuilderMapper(configuration);
        String host = "localhost";
        String cluster = "ConnectinGEO";
        String index = "geodab";
        String type = "dcrecord";
        int port = 9301;
        ElasticsearchRemoteHttpSink sink = new ElasticsearchRemoteHttpSink(host, port, cluster, index, type);
        SingleThreadBulkRunner runner = new SingleThreadBulkRunner().setBulkSize(20L).setRecordsLimit(10L).setStartPosition(1L).harvest(source).transform(mapper);
        Report report = runner.load(sink);
        return report;
    }
}

