/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.harvest;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.n52.youngs.api.Report;
import org.n52.youngs.exception.SourceError;
import org.n52.youngs.harvest.NodeSourceRecord;
import org.n52.youngs.harvest.Source;
import org.n52.youngs.harvest.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DirectorySource
implements Source {
    private static final Logger log = LoggerFactory.getLogger(DirectorySource.class);
    private static final FileFilter DEFAULT_FILTER = pathname -> true;
    private final Path directory;
    private Optional<List<SourceRecord>> records = Optional.empty();
    private FileFilter filter;
    private DocumentBuilderFactory docBuilderFactory;

    public DirectorySource(Path directory) {
        this(directory, DEFAULT_FILTER);
    }

    public DirectorySource(Path directory, FileFilter filter) {
        Objects.nonNull(directory);
        if (!directory.toFile().isDirectory() && !directory.toFile().exists()) {
            throw new IllegalArgumentException(String.format("Provided path %s is not an (existing) directory", directory));
        }
        Objects.nonNull(filter);
        this.filter = filter;
        this.directory = directory;
        this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.docBuilderFactory.setNamespaceAware(true);
    }

    @Override
    public URL getEndpoint() {
        try {
            return this.directory.toFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SourceError(e, "Could not create URL from directory %s", this.directory);
        }
    }

    @Override
    public long getRecordCount() {
        return this.getFiles().length;
    }

    @Override
    public Collection<SourceRecord> getRecords(Report report) {
        return this.readRecordsFromDirectory();
    }

    @Override
    public Collection<SourceRecord> getRecords(long startPosition, long maxRecords, Report report) {
        List<SourceRecord> sorted = this.readRecordsFromDirectory();
        int calculatedBegin = (int)(startPosition - 1L);
        int calculatedEnd = (int)Math.min((long)sorted.size(), (long)calculatedBegin + maxRecords);
        log.trace("Mapped subsetting from start={} max={} to [{}, {}[(exclusive) for {} records", new Object[]{startPosition, maxRecords, calculatedBegin, calculatedEnd, sorted.size()});
        return sorted.subList(calculatedBegin, calculatedEnd);
    }

    private File[] getFiles() {
        return this.directory.toFile().listFiles(this.filter);
    }

    private List<SourceRecord> readRecordsFromDirectory() {
        if (this.records.isPresent()) {
            return this.records.get();
        }
        List recs = Arrays.stream(this.getFiles()).map(file -> {
            try {
                SourceRecord record = this.readRecordFromFile((File)file);
                log.trace("Parsed record: {}", (Object)record);
                return record;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                log.warn("Could not parse file {}: {} (turn on debug for full trace)", file, (Object)e.getMessage());
                log.debug("Error reading file {}", file, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.records = Optional.of(recs);
        return this.records.get();
    }

    private SourceRecord readRecordFromFile(File f) throws ParserConfigurationException, SAXException, IOException {
        log.debug("Reading record from file {}", (Object)f);
        DocumentBuilder documentBuilder = this.docBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.parse(f);
        Element elem = doc.getDocumentElement();
        elem.normalize();
        log.trace("Read document: {}", (Object)elem);
        NodeSourceRecord record = new NodeSourceRecord(elem);
        return record;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("directory", (Object)this.directory).add("filter", (Object)this.filter).omitNullValues().toString();
    }
}

