/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class NamespaceContextImpl
implements NamespaceContext {
    private final BiMap<String, String> prefixToNamespace = HashBiMap.create();

    public NamespaceContextImpl(Map<String, String> namespaceMap) {
        this.prefixToNamespace.putAll(namespaceMap);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return (String)this.prefixToNamespace.get((Object)prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return (String)this.prefixToNamespace.inverse().get((Object)namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return Collections.singleton(this.getPrefix(namespaceURI)).iterator();
    }

    public static NamespaceContext create() {
        return new NamespaceContextImpl((Map<String, String>)new ImmutableMap.Builder().put((Object)"gmd", (Object)"http://www.isotc211.org/2005/gmd").put((Object)"gco", (Object)"http://www.isotc211.org/2005/gco").put((Object)"eum", (Object)"http://www.eumetsat.int/2008/gmi").put((Object)"gmi", (Object)"http://www.isotc211.org/2005/gmi").put((Object)"ogc", (Object)"http://www.opengis.net/ogc").put((Object)"xlink", (Object)"http://www.w3.org/1999/xlink").put((Object)"fn", (Object)"http://www.w3.org/TR/xpath-functions").put((Object)"str", (Object)"http://exslt.org/strings").put((Object)"xdt", (Object)"http://www.w3.org/2005/02/xpath-datatypes").put((Object)"xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance").put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema").put((Object)"ows", (Object)"http://www.opengis.net/ows").put((Object)"csw", (Object)"http://www.opengis.net/cat/csw/2.0.2").put((Object)"srv", (Object)"http://www.isotc211.org/2005/srv").put((Object)"dc", (Object)"http://purl.org/dc/elements/1.1/").put((Object)"dct", (Object)"http://purl.org/dc/terms/").put((Object)"inspire_ds", (Object)"http://inspire.ec.europa.eu/schemas/inspire_ds/1.0").put((Object)"inspire_c", (Object)"http://inspire.ec.europa.eu/schemas/common/1.0").build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespaces", (Object)Arrays.deepToString(this.prefixToNamespace.entrySet().toArray())).toString();
    }
}

