/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.impl;

import java.io.StringReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XPathHelper {
    private static final Logger log = LoggerFactory.getLogger(XPathHelper.class);
    private final String systemSettingKey;
    private final String systemSettingValue;
    private final String objectModel;

    public XPathHelper() {
        this("javax.xml.xpath.XPathFactory:http://saxon.sf.net/jaxp/xpath/om", "net.sf.saxon.xpath.XPathFactoryImpl", "http://saxon.sf.net/jaxp/xpath/om");
    }

    public XPathHelper(String systemSettingKey, String systemSettingValue, String objectModel) {
        this.systemSettingKey = systemSettingKey;
        this.systemSettingValue = systemSettingValue;
        this.objectModel = objectModel;
    }

    private void setSystemSetting() {
        System.setProperty(this.systemSettingKey, this.systemSettingValue);
        log.info("Setting system property {} to {}", (Object)this.systemSettingKey, (Object)this.systemSettingValue);
    }

    private void unsetSystemSetting() {
        System.clearProperty(this.systemSettingKey);
        log.info("Unsetting system property {}", (Object)this.systemSettingKey);
    }

    public synchronized XPathFactory newXPathFactory() {
        this.setSystemSetting();
        XPathFactory factory = null;
        try {
            factory = XPathFactory.newInstance(this.objectModel);
        }
        catch (XPathFactoryConfigurationException e) {
            log.error("Could not create new instance of XPathFactory", (Throwable)e);
        }
        this.unsetSystemSetting();
        return factory;
    }

    public boolean isVersionSupported(XPathFactory factory, String version) {
        switch (version) {
            case "2.0": {
                return this.isXPath20Supported(factory);
            }
            case "1.0": {
                return this.isXPath10Supported(factory);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown XSLT version %s", version));
    }

    public boolean isXPath10Supported(XPathFactory factory) {
        return true;
    }

    public boolean isXPath20Supported(XPathFactory factory) {
        try {
            XPath xpath = factory.newXPath();
            String evaluate = xpath.evaluate("current-date()", new InputSource(new StringReader("<empty />")));
            log.trace("Evaluated current-date() to {} as a quick check for XSLT 2.0 support", (Object)evaluate);
            return !evaluate.isEmpty();
        }
        catch (XPathExpressionException e) {
            log.debug("Error evaluating test expression, 2.0 not supported.", (Object)e.getMessage());
            return false;
        }
    }
}

