/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.load.impl;

import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.n52.youngs.load.impl.ElasticsearchSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchRemoteHttpSink
extends ElasticsearchSink {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchRemoteHttpSink.class);
    private final String host;
    private final int port;
    private final TransportClient client;

    public ElasticsearchRemoteHttpSink(String host, int port, String cluster, String index, String type) {
        super(cluster, index, type);
        this.host = host;
        this.port = port;
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.getCluster()).build();
        this.client = new TransportClient(settings).addTransportAddress((TransportAddress)new InetSocketTransportAddress(this.host, this.port));
        log.info("Created new client with settings {}", (Object)settings);
    }

    @Override
    public Client getClient() {
        return this.client;
    }
}

