/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.load.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.indices.IndexMissingException;
import org.joda.time.DateTimeZone;
import org.n52.iceland.statistics.api.mappings.MetadataDataMapping;
import org.n52.iceland.statistics.api.parameters.AbstractEsParameter;
import org.n52.iceland.statistics.api.parameters.ObjectEsParameter;
import org.n52.iceland.statistics.api.parameters.SingleEsParameter;
import org.n52.youngs.exception.SinkError;
import org.n52.youngs.load.SchemaGenerator;
import org.n52.youngs.load.Sink;
import org.n52.youngs.load.SinkRecord;
import org.n52.youngs.load.impl.BuilderRecord;
import org.n52.youngs.load.impl.SchemaGeneratorImpl;
import org.n52.youngs.load.impl.YoungsMetadataDataMapping;
import org.n52.youngs.transform.MappingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticsearchSink
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchSink.class);
    private final String cluster;
    private final String index;
    private final String type;
    protected SchemaGenerator schemaGenerator = new SchemaGeneratorImpl();

    public ElasticsearchSink(String cluster, String index, String type) {
        this.cluster = cluster;
        this.index = index;
        this.type = type;
    }

    public abstract Client getClient();

    protected String getCluster() {
        return this.cluster;
    }

    @Override
    public boolean store(SinkRecord record) {
        log.trace("Storing record: {}", (Object)record);
        Objects.nonNull(record);
        if (record instanceof BuilderRecord) {
            BuilderRecord builderRecord = (BuilderRecord)record;
            Client client = this.getClient();
            log.trace("Indexing record: {}", (Object)record);
            IndexRequestBuilder request = client.prepareIndex(this.index, this.type).setSource(builderRecord.getBuilder());
            if (record.hasId()) {
                request.setId(builderRecord.getId());
            }
            try {
                IndexResponse response = (IndexResponse)request.execute().actionGet();
                log.trace("Created [{}] with id {} @ {}/{}, version {}", new Object[]{response.isCreated(), response.getId(), response.getIndex(), response.getType(), response.getVersion()});
                return response.isCreated() || !response.isCreated() && response.getVersion() > 1L;
            }
            catch (ElasticsearchException e) {
                log.error("Could not store record {}", (Object)builderRecord.getId(), (Object)e);
                return false;
            }
        }
        throw new SinkError("The provided record class '%s' is not supported", record.getClass());
    }

    @Override
    public boolean store(Collection<SinkRecord> records) {
        long addedRecords = records.stream().map(this::store).filter(b -> b).count();
        return addedRecords == (long)records.size();
    }

    public ElasticsearchSink setSchemaGenerator(SchemaGenerator sg) {
        this.schemaGenerator = sg;
        return this;
    }

    @Override
    public boolean prepare(MappingConfiguration mapping) {
        if (!mapping.isIndexCreationEnabled()) {
            log.info("Index creation is disabled, stopping preparations!");
            return false;
        }
        try {
            IndicesAdminClient indices = this.getClient().admin().indices();
            String indexId = mapping.getIndex();
            if (((IndicesExistsResponse)indices.prepareExists(new String[]{indexId}).get()).isExists()) {
                log.info("Index {} already exists, updating the mapping ...", (Object)indexId);
                return this.updateMapping(indexId, mapping);
            }
            log.info("Index {} does not exist, creating it ...", (Object)indexId);
            return this.createMapping(mapping, indexId);
        }
        catch (RuntimeException e) {
            throw new SinkError(e, "Problem preparing sink: %s", e.getMessage());
        }
    }

    protected boolean createMapping(MappingConfiguration mapping, String indexId) {
        IndicesAdminClient indices = this.getClient().admin().indices();
        Map<String, Object> schema = this.schemaGenerator.generate(mapping);
        log.trace("Built schema creation request:\n{}", (Object)Arrays.toString(schema.entrySet().toArray()));
        CreateIndexRequestBuilder request = indices.prepareCreate(indexId).addMapping("mt", this.getMetadataSchema()).addMapping(mapping.getType(), schema);
        if (mapping.hasIndexCreationRequest()) {
            request.setSettings(mapping.getIndexCreationRequest());
        }
        CreateIndexResponse response = (CreateIndexResponse)request.get();
        log.debug("Created indices: {}, acknowledged: {}", (Object)response, (Object)response.isAcknowledged());
        Map<String, Object> mdRecord = this.createMetadataRecord(mapping.getVersion(), mapping.getName());
        IndexResponse mdResponse = (IndexResponse)this.getClient().prepareIndex(indexId, "mt", "1").setSource(mdRecord).get();
        log.debug("Saved mapping metadata '{}': {}", (Object)mdResponse.isCreated(), (Object)Arrays.toString(mdRecord.entrySet().toArray()));
        return mdResponse.isCreated() && response.isAcknowledged();
    }

    protected boolean updateMapping(String indexId, MappingConfiguration mapping) throws SinkError {
        double version = this.getCurrentVersion(indexId);
        log.info("Existing mapping version is {}, vs. c version {}", (Object)version, (Object)mapping.getVersion());
        if (version < 0.0) {
            throw new SinkError("Database inconsistency. Metadata version not found in type %s", "mt");
        }
        if (version != (double)mapping.getVersion()) {
            throw new SinkError("Database schema version inconsistency. Version numbers don't match. Database version number %d != mapping version number %d", version, mapping.getVersion());
        }
        Map<String, Object> schema = this.schemaGenerator.generate(mapping);
        PutMappingRequestBuilder request = this.getClient().admin().indices().preparePutMapping(new String[]{indexId}).setType(mapping.getType()).setSource(schema);
        PutMappingResponse updateMappingResponse = (PutMappingResponse)request.get();
        log.info("Update mapping of type {} acknowledged: {}", (Object)mapping.getType(), (Object)updateMappingResponse.isAcknowledged());
        if (!updateMappingResponse.isAcknowledged()) {
            log.error("Problem updating mapping for type {}", (Object)mapping.getType());
        }
        Map<String, Object> updatedMetadata = this.createUpdatedMetadata(indexId);
        UpdateResponse mdUpdate = (UpdateResponse)this.getClient().prepareUpdate(indexId, "mt", "1").setDoc(updatedMetadata).get();
        log.info("Update metadata record created: {} | id = {} @ {}/{}", new Object[]{mdUpdate.isCreated(), mdUpdate.getId(), mdUpdate.getIndex(), mdUpdate.getType()});
        return mdUpdate.getId().equals("1") && updateMappingResponse.isAcknowledged();
    }

    private double getCurrentVersion(String indexId) {
        GetResponse resp = (GetResponse)((GetRequestBuilder)this.getClient().prepareGet(indexId, "mt", "1").setOperationThreaded(false)).get();
        if (resp.isExists()) {
            Object versionString = resp.getSourceAsMap().get(MetadataDataMapping.METADATA_VERSION_FIELD.getName());
            if (versionString == null) {
                throw new ElasticsearchException(String.format("Database inconsistency. Version can't be found in row %s/%s/%s", indexId, "mt", "1"));
            }
            return Double.valueOf(versionString.toString());
        }
        return Double.MIN_VALUE;
    }

    private Map<String, Object> createUpdatedMetadata(String indexId) throws SinkError {
        List<String> values;
        GetResponse resp = (GetResponse)((GetRequestBuilder)this.getClient().prepareGet(indexId, "mt", "1").setOperationThreaded(false)).get();
        Object retrievedValues = resp.getSourceAsMap().get(MetadataDataMapping.METADATA_UUIDS_FIELD.getName());
        if (retrievedValues instanceof String) {
            values = new LinkedList<String>();
            values.add((String)retrievedValues);
        } else if (retrievedValues instanceof List) {
            values = (List)retrievedValues;
        } else {
            throw new SinkError("Invalid %s field type %s should have String or java.util.Collection<String>", MetadataDataMapping.METADATA_UUIDS_FIELD, retrievedValues.getClass());
        }
        String uuid = UUID.randomUUID().toString();
        HashMap updatedMetadata = Maps.newHashMap();
        values.add(uuid);
        updatedMetadata.put(MetadataDataMapping.METADATA_UUIDS_FIELD.getName(), values);
        updatedMetadata.put(MetadataDataMapping.METADATA_UPDATE_TIME_FIELD.getName(), Calendar.getInstance(DateTimeZone.UTC.toTimeZone()));
        log.info("UUID {} is added to the {} type", (Object)uuid, (Object)"mt");
        return updatedMetadata;
    }

    private Map<String, Object> getMetadataSchema() {
        HashMap mappings = Maps.newHashMap();
        for (Field field : MetadataDataMapping.class.getDeclaredFields()) {
            AbstractEsParameter value = this.checkField(field);
            if (value == null) continue;
            this.resolveParameterField(value, mappings);
        }
        HashMap properties = Maps.newHashMapWithExpectedSize((int)1);
        properties.put("properties", mappings);
        return properties;
    }

    private void resolveParameterField(AbstractEsParameter value, Map<String, Object> map) {
        if (value instanceof SingleEsParameter) {
            SingleEsParameter single = (SingleEsParameter)value;
            map.put(single.getName(), single.getTypeAsMap());
        } else if (value instanceof ObjectEsParameter) {
            ObjectEsParameter object = (ObjectEsParameter)value;
            HashMap<String, HashMap<String, Object>> subproperties = new HashMap<String, HashMap<String, Object>>(1);
            HashMap<String, Object> childrenMap = new HashMap<String, Object>(value.getAllChildren().size());
            subproperties.put("properties", childrenMap);
            for (AbstractEsParameter child : object.getAllChildren()) {
                this.resolveParameterField(child, childrenMap);
            }
            map.put(object.getName(), subproperties);
        } else {
            throw new IllegalArgumentException("Invalid schema parameter value " + value.toString());
        }
    }

    private AbstractEsParameter checkField(Field field) {
        boolean bool = Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers());
        boolean bl = bool = bool && field.getType().isAssignableFrom(AbstractEsParameter.class);
        if (bool) {
            try {
                return (AbstractEsParameter)field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error("Error retrieving field.", (Throwable)e);
            }
        }
        return null;
    }

    private Map<String, Object> createMetadataRecord(int version, String name) {
        String uuid = UUID.randomUUID().toString();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar time = Calendar.getInstance(DateTimeZone.UTC.toTimeZone());
        data.put(MetadataDataMapping.METADATA_CREATION_TIME_FIELD.getName(), time);
        data.put(MetadataDataMapping.METADATA_UPDATE_TIME_FIELD.getName(), time);
        data.put(MetadataDataMapping.METADATA_VERSION_FIELD.getName(), version);
        data.put(YoungsMetadataDataMapping.METADATA_NAME_FIELD.getName(), name);
        data.put(MetadataDataMapping.METADATA_UUIDS_FIELD.getName(), uuid);
        log.info("Initial metadata is created ceated for type {} with uuid {} @ {}", new Object[]{"mt", uuid, time});
        return data;
    }

    @Override
    public boolean clear(MappingConfiguration mapping) {
        log.info("Deleting index '{}'", (Object)mapping.getIndex());
        DeleteIndexRequest request = new DeleteIndexRequest(mapping.getIndex());
        try {
            DeleteIndexResponse delete = (DeleteIndexResponse)this.getClient().admin().indices().delete(request).actionGet();
            log.info("Delete acknowledged: {}", (Object)delete.isAcknowledged());
            return delete.isAcknowledged();
        }
        catch (IndexMissingException e) {
            log.info("Index does not exist, no need to delete: {}", (Object)e.getMessage());
            return true;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("index", (Object)this.index).add("type", (Object)this.type).add("client", (Object)this.getClient()).toString();
    }
}

