/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.load.impl;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.n52.youngs.load.SchemaGenerator;
import org.n52.youngs.transform.MappingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaGeneratorImpl
implements SchemaGenerator {
    private static final Logger log = LoggerFactory.getLogger(SchemaGeneratorImpl.class);

    @Override
    public Map<String, Object> generate(MappingConfiguration mapping) {
        HashMap schema = Maps.newHashMap();
        schema.put("dynamic", mapping.isDynamicMappingEnabled());
        HashMap fields = Maps.newHashMap();
        mapping.getEntries().forEach(entry -> {
            HashMap properties = Maps.newHashMap();
            for (Map.Entry<String, Object> entryProps : entry.getIndexProperties().entrySet()) {
                properties.put(entryProps.getKey(), entryProps.getValue());
            }
            fields.put(entry.getFieldName(), properties);
        });
        schema.put("properties", fields);
        log.info("Created {} schema with {} fields", (Object)(mapping.isDynamicMappingEnabled() ? "dynamic" : ""), (Object)fields.size());
        log.debug("Created schema with {} first level elements: {}", (Object)schema.size(), (Object)Arrays.deepToString(schema.entrySet().toArray()));
        return schema;
    }
}

