/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.transform.impl;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.n52.youngs.harvest.NodeSourceRecord;
import org.n52.youngs.harvest.SourceRecord;
import org.n52.youngs.load.impl.BuilderRecord;
import org.n52.youngs.transform.Mapper;
import org.n52.youngs.transform.MappingConfiguration;
import org.n52.youngs.transform.MappingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CswToBuilderMapper
implements Mapper {
    private static final Logger log = LoggerFactory.getLogger(CswToBuilderMapper.class);
    private final MappingConfiguration mapper;
    private final TransformerFactory tFactory = TransformerFactory.newInstance();
    private static final Map<String, String> DEFAULT_OUTPUT_PROPERTIES = ImmutableMap.of((Object)"omit-xml-declaration", (Object)"no", (Object)"indent", (Object)"no", (Object)"encoding", (Object)Charsets.UTF_8.name());
    private Optional<Transformer> stripspaceTransformer = Optional.empty();

    public CswToBuilderMapper(MappingConfiguration mapper) {
        this.mapper = mapper;
        try (InputStream is = Resources.getResource((String)"xslt/stripspace.xslt").openStream();){
            StreamSource xslt = new StreamSource(is);
            this.stripspaceTransformer = Optional.of(this.tFactory.newTransformer(xslt));
            log.trace("Will apply stripspace XSLT.");
        }
        catch (IOException | TransformerConfigurationException e) {
            log.error("Problem loading strip-space XSLT file.", (Throwable)e);
        }
    }

    @Override
    public MappingConfiguration getMapper() {
        return this.mapper;
    }

    @Override
    public BuilderRecord map(SourceRecord sourceRecord) {
        Objects.nonNull(sourceRecord);
        BuilderRecord record = null;
        if (sourceRecord instanceof NodeSourceRecord) {
            try {
                NodeSourceRecord object = (NodeSourceRecord)sourceRecord;
                IdAndBuilder mappedRecord = this.mapNodeToBuilder(object.getRecord());
                record = new BuilderRecord(mappedRecord.id, mappedRecord.builder);
                return record;
            }
            catch (IOException e) {
                log.warn("Error mapping the source {}", (Object)sourceRecord, (Object)e);
                return null;
            }
        }
        log.warn("The SourceRecord class {} is not supported", (Object)sourceRecord.getClass().getName());
        return record;
    }

    private IdAndBuilder mapNodeToBuilder(Node node) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().humanReadable(true).prettyPrint().startObject();
        Collection<MappingEntry> entries = this.mapper.getEntries();
        log.trace("Mapping node {} using {} entries", (Object)node, (Object)entries.size());
        String id = null;
        try {
            Optional<MappingEntry> idEntry = entries.stream().filter(MappingEntry::isIdentifier).findFirst();
            if (idEntry.isPresent()) {
                id = idEntry.get().getXPath().evaluate(node);
                log.trace("Found id for node: {}", (Object)id);
            }
        }
        catch (XPathExpressionException e2) {
            log.warn("Error selecting id field from node", (Throwable)e2);
        }
        entries.stream().filter(e -> !e.hasCoordinates() && !e.isRawXml()).forEach(entry -> this.mapEntry((MappingEntry)entry, node, builder));
        entries.stream().filter(e -> e.hasCoordinates() && !e.isRawXml()).forEach(entry -> this.mapSpatialEntry((MappingEntry)entry, node, builder));
        entries.stream().filter(e -> e.isRawXml()).forEach(entry -> this.mapRawEntry((MappingEntry)entry, node, builder));
        builder.endObject();
        builder.close();
        log.trace("Created content for id '{}':\n{}", (Object)id, (Object)builder.string());
        return new IdAndBuilder(id, builder);
    }

    private void mapSpatialEntry(MappingEntry entry, Node node, XContentBuilder builder) {
        log.trace("Applying field mapping '{}' to node: {}", (Object)entry.getFieldName(), (Object)node);
        try {
            Object coordsNode = entry.getXPath().evaluate(node, XPathConstants.NODE);
            if (coordsNode != null) {
                String geoType = (String)entry.getIndexPropery("type");
                String field = (String)entry.getIndexPropery("index_name");
                List<XPathExpression[]> pointsXPaths = entry.getCoordinatesXPaths();
                if (!pointsXPaths.isEmpty() && !geoType.isEmpty() && !field.isEmpty() && entry.hasCoordinatesType()) {
                    List pointsDoubles = pointsXPaths.stream().map((? super T p) -> {
                        try {
                            Number lat = (Number)p[0].evaluate(coordsNode, XPathConstants.NUMBER);
                            Number lon = (Number)p[1].evaluate(coordsNode, XPathConstants.NUMBER);
                            return new Number[]{lon, lat};
                        }
                        catch (XPathExpressionException e) {
                            log.warn("Error evaluating XPath {} for coordinate: {}", p, (Object)e);
                            return null;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    log.trace("Evaluated {} expressions and got {} points: {}", new Object[]{pointsXPaths.size(), pointsDoubles.size(), Arrays.deepToString(pointsDoubles.toArray())});
                    builder.startObject(field).field("type", entry.getCoordinatesType()).field("coordinates", pointsDoubles).endObject();
                    log.debug("Added points '{}' as {} of type {}", new Object[]{Arrays.deepToString(pointsDoubles.toArray()), geoType, entry.getCoordinatesType()});
                } else {
                    log.warn("Mapping '{}' has coordinates but is missing one of the other required settings, not adding field: node = {}, index_name = {}, coordinates_type = {}, type = {}, points = {}", new Object[]{entry.getFieldName(), coordsNode, field, entry.getCoordinatesType(), geoType, Arrays.deepToString(pointsXPaths.toArray())});
                }
            } else {
                log.warn("Coords node is null, no result evaluating {} on {]", (Object)entry.getXPath(), (Object)node);
            }
        }
        catch (IOException | XPathExpressionException e) {
            log.warn("Error selecting coordinate-field {} as node. Error was: {}", (Object)entry.getFieldName(), (Object)e.getMessage());
            log.trace("Error selecting field {} as nodeset", (Object)entry.getFieldName(), (Object)e);
        }
    }

    private void mapEntry(MappingEntry entry, Node node, XContentBuilder builder) {
        log.trace("Applying field mapping '{}' to node: {}", (Object)entry.getFieldName(), (Object)node);
        Optional<Object> result = Optional.empty();
        try {
            Object nodesetResult = entry.getXPath().evaluate(node, XPathConstants.NODESET);
            result = Optional.ofNullable(this.handleEvaluationResult(nodesetResult, entry.getFieldName()));
            if (result.isPresent()) {
                log.trace("Found nodeset result: {}", result.get());
            }
        }
        catch (XPathExpressionException e) {
            log.debug("Error selecting field {} as nodeset, could be XPath 2.0 expression... trying evaluation to string. Error was: {}", (Object)entry.getFieldName(), (Object)e.getMessage());
            log.trace("Error selecting field {} as nodeset", (Object)entry.getFieldName(), (Object)e);
        }
        if (!result.isPresent()) {
            try {
                String stringResult = (String)entry.getXPath().evaluate(node, XPathConstants.STRING);
                result = Optional.ofNullable(this.handleEvaluationResult(stringResult, entry.getFieldName()));
                if (result.isPresent()) {
                    log.trace("Found string result: {}", result.get());
                }
            }
            catch (XPathExpressionException e) {
                log.warn("Error selecting field {} as string: {}", (Object)entry.getFieldName(), (Object)e.getMessage());
                log.trace("Error selecting field {} as string", (Object)entry.getFieldName(), (Object)e);
            }
        }
        if (result.isPresent()) {
            EvalResult er = (EvalResult)result.get();
            if (entry.hasReplacements()) {
                er = this.handleReplacements(entry, er);
            }
            if (entry.hasSplit()) {
                er = this.handleSplit(entry, er);
            }
            try {
                Object value = er.value;
                builder.field(er.name, value);
                log.debug("Added field: {} = {}", (Object)er.name, value instanceof Object[] ? Arrays.toString((Object[])value) : value);
            }
            catch (IOException e) {
                log.warn("Error adding field {}: {}", (Object)entry.getFieldName(), (Object)e);
            }
        }
    }

    private EvalResult handleReplacements(MappingEntry entry, EvalResult er) {
        EvalResult result = null;
        Map<String, String> replacements = entry.getReplacements();
        log.trace("Applying replacements in {}: {}", (Object)er.name, (Object)Arrays.toString(replacements.entrySet().toArray()));
        if (er.value instanceof String) {
            result = new EvalResult(er.name, this.applyReplacements(replacements, (String)er.value));
        } else if (er.value instanceof String[]) {
            String[] val = (String[])er.value;
            result = new EvalResult(er.name, Arrays.stream(val).map((? super T currentVal) -> this.applyReplacements(replacements, (String)currentVal)).collect(Collectors.toList()).toArray());
        } else if (er.value instanceof Object[]) {
            Object[] val = (Object[])er.value;
            result = new EvalResult(er.name, Arrays.stream(val).filter(v -> v instanceof String).filter(Objects::nonNull).map((? super T v) -> (String)v).map((? super T currentVal) -> this.applyReplacements(replacements, (String)currentVal)).collect(Collectors.toList()).toArray());
        }
        log.trace("Result after replacements: {} (if null, then the original is returned)", (Object)result);
        if (result != null) {
            return result;
        }
        log.debug("No handling of replacement for given result implemented, returning input again: {}", (Object)er);
        return er;
    }

    private String applyReplacements(Map<String, String> replacements, String in) {
        String out = in;
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            out = out.replace(replacement.getKey(), replacement.getValue());
        }
        return out;
    }

    private EvalResult handleSplit(MappingEntry entry, EvalResult er) {
        if (er.value instanceof String) {
            String value = (String)er.value;
            log.trace("Applying split in field {} with '{}' on {}", new Object[]{entry.getFieldName(), entry.getSplit(), value});
            String[] split = value.split(entry.getSplit());
            List<String> list = Arrays.asList(split);
            log.trace("Split resulted in {} items: {}", (Object)list.size(), (Object)Arrays.toString(list.toArray()));
            return new EvalResult(er.name, list);
        }
        log.trace("Split can only be applied to string value, but result was {} ({})", er.value, er.value.getClass());
        return er;
    }

    private void mapRawEntry(MappingEntry entry, Node node, XContentBuilder builder) {
        try {
            Node nodesetResult = (Node)entry.getXPath().evaluate(node, XPathConstants.NODE);
            HashMap outputProperties = Maps.newHashMap();
            outputProperties.putAll(DEFAULT_OUTPUT_PROPERTIES);
            if (entry.hasOutputProperties()) {
                outputProperties.putAll(entry.getOutputProperties());
            }
            String xmldoc = this.asString(nodesetResult, outputProperties);
            log.trace("Storing full XML to field {} starting with {}", (Object)entry.getFieldName(), (Object)xmldoc.substring(0, Math.min(xmldoc.length(), 120)));
            builder.field(entry.getFieldName(), xmldoc);
        }
        catch (IOException | XPathExpressionException e) {
            log.warn("Error adding field {}: {}", (Object)entry.getFieldName(), (Object)e);
        }
    }

    private EvalResult handleEvaluationResult(Object evalutationResult, String name) {
        if (evalutationResult instanceof String) {
            String valueString = (String)evalutationResult;
            if (!valueString.isEmpty()) {
                log.trace("Found field {} = {}", (Object)name, (Object)valueString);
                return new EvalResult(name, valueString);
            }
            log.debug("Evaluation returned empty string for entry {}", (Object)name);
        } else if (evalutationResult instanceof NodeList) {
            NodeList nodeList = (NodeList)evalutationResult;
            Optional<Object> value = Optional.empty();
            if (nodeList.getLength() < 1) {
                log.debug("Evaluation returned no results for entry {}", (Object)name);
            } else {
                HashSet contents = Sets.newHashSet();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node n = nodeList.item(i);
                    String textContent = n.getTextContent();
                    if (textContent == null || textContent.isEmpty()) continue;
                    contents.add(textContent);
                }
                log.trace("{} evaluation result(s): {} = {}", new Object[]{contents.size(), name, Arrays.toString(contents.toArray())});
                if (contents.size() == 1) {
                    value = Optional.of(contents.iterator().next());
                    log.trace("Adding field {} = '{}'", (Object)name, value.get());
                }
                if (contents.size() > 1) {
                    value = Optional.of(contents.toArray());
                    log.trace("Adding array field ({} values) {} = {}", new Object[]{contents.size(), name, Arrays.toString(contents.toArray())});
                }
            }
            if (value.isPresent()) {
                return new EvalResult(name, value.get());
            }
            log.trace("No result found for field {}", (Object)name);
        } else {
            log.debug("Unsupported evalutation result: {}", evalutationResult);
        }
        return null;
    }

    private String asString(Node node, Map<String, String> outputProperties) {
        log.debug("Converting node {} to string using properties {}", (Object)node, (Object)Arrays.toString(outputProperties.entrySet().toArray()));
        StringWriter sw = new StringWriter();
        try {
            Transformer t = null;
            if (outputProperties.get("indent").equals("no") && this.stripspaceTransformer.isPresent()) {
                t = this.stripspaceTransformer.get();
                log.trace("Will apply stripspace XSLT.");
            } else {
                t = this.tFactory.newTransformer();
            }
            for (Map.Entry<String, String> op : outputProperties.entrySet()) {
                t.setOutputProperty(op.getKey(), op.getValue());
            }
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException e) {
            log.warn("Problem getting node {} as string", (Object)node, (Object)e);
        }
        return sw.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mapping", (Object)this.mapper).add("transformerFactory", (Object)this.tFactory).omitNullValues().toString();
    }

    private static class EvalResult {
        protected final String name;
        protected final Object value;

        public EvalResult(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.value).omitNullValues().toString();
        }
    }

    private static class IdAndBuilder {
        protected final String id;
        protected final XContentBuilder builder;

        public IdAndBuilder(String id, XContentBuilder builder) {
            Objects.nonNull(builder);
            this.id = id;
            this.builder = builder;
        }
    }
}

