/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.transform.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.xpath.XPathExpression;
import org.n52.youngs.transform.MappingEntry;

public class MappingEntryImpl
implements MappingEntry {
    private final XPathExpression xPath;
    private final Map<String, Object> indexProperties = Maps.newHashMap();
    private Optional<Boolean> identifier = Optional.empty();
    private Optional<Boolean> location = Optional.empty();
    private Optional<List<XPathExpression[]>> coordinates = Optional.empty();
    private Optional<String> coordinatesType = Optional.empty();
    private Optional<Boolean> raw = Optional.empty();
    private Optional<Map<String, String>> replacements = Optional.empty();
    private Optional<Map<String, String>> outputProperties = Optional.empty();
    private Optional<String> split = Optional.empty();

    public MappingEntryImpl(XPathExpression xPath, Map<String, Object> indexProperties, boolean identifier, boolean location, boolean rawXml) {
        this.xPath = xPath;
        this.indexProperties.putAll(indexProperties);
        this.identifier = Optional.of(identifier);
        this.location = Optional.of(location);
        this.raw = Optional.of(rawXml);
    }

    @Override
    public XPathExpression getXPath() {
        return this.xPath;
    }

    @Override
    public String getFieldName() {
        return (String)this.indexProperties.get("index_name");
    }

    public MappingEntryImpl addIndexProperty(String key, Object value) {
        this.indexProperties.put(key, value);
        return this;
    }

    @Override
    public Map<String, Object> getIndexProperties() {
        return this.indexProperties;
    }

    @Override
    public Object getIndexPropery(String name) {
        return this.indexProperties.get(name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("xpath", (Object)this.xPath).add("identifer", this.identifier.orElse(null)).add("location", this.location.orElse(null)).add("raw", this.raw.orElse(null)).add("properties", (Object)Arrays.deepToString(this.indexProperties.entrySet().toArray())).omitNullValues().toString();
    }

    @Override
    public boolean isIdentifier() {
        return this.identifier.isPresent() && this.identifier.get() != false;
    }

    @Override
    public boolean isLocation() {
        return this.location.isPresent() && this.location.get() != false;
    }

    @Override
    public boolean hasCoordinates() {
        return this.coordinates.isPresent();
    }

    @Override
    public List<XPathExpression[]> getCoordinatesXPaths() {
        return this.coordinates.get();
    }

    public MappingEntryImpl setCoordinatesXPaths(List<XPathExpression[]> coords) {
        this.coordinates = Optional.of(coords);
        return this;
    }

    @Override
    public boolean hasCoordinatesType() {
        return this.coordinatesType.isPresent();
    }

    @Override
    public String getCoordinatesType() {
        return this.coordinatesType.get();
    }

    public MappingEntryImpl setCoordinatesType(String type) {
        this.coordinatesType = Optional.of(type);
        return this;
    }

    @Override
    public boolean isRawXml() {
        return this.raw.isPresent() && this.raw.get() != false;
    }

    @Override
    public boolean hasReplacements() {
        return this.replacements.isPresent();
    }

    @Override
    public Map<String, String> getReplacements() {
        return this.replacements.get();
    }

    public MappingEntryImpl setReplacements(Map<String, String> replacements) {
        this.replacements = Optional.of(replacements);
        return this;
    }

    @Override
    public boolean hasOutputProperties() {
        return this.outputProperties.isPresent();
    }

    public Map<String, String> getOutputProperties() {
        return this.outputProperties.get();
    }

    public void setOutputProperties(Map<String, String> properties) {
        this.outputProperties = Optional.of(properties);
    }

    @Override
    public boolean hasSplit() {
        return this.split.isPresent();
    }

    @Override
    public String getSplit() {
        return this.split.get();
    }

    public MappingEntryImpl setSplit(String split) {
        this.split = Optional.of(split);
        return this;
    }
}

