/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.transform.impl;

import com.github.autermann.yaml.Yaml;
import com.github.autermann.yaml.YamlNode;
import com.github.autermann.yaml.nodes.YamlBooleanNode;
import com.github.autermann.yaml.nodes.YamlDecimalNode;
import com.github.autermann.yaml.nodes.YamlIntegralNode;
import com.github.autermann.yaml.nodes.YamlMapNode;
import com.github.autermann.yaml.nodes.YamlSeqNode;
import com.github.autermann.yaml.nodes.YamlTextNode;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.n52.youngs.exception.MappingError;
import org.n52.youngs.impl.XPathHelper;
import org.n52.youngs.transform.MappingConfiguration;
import org.n52.youngs.transform.MappingEntry;
import org.n52.youngs.transform.impl.MappingEntryImpl;
import org.n52.youngs.transform.impl.NamespacedYamlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class YamlMappingConfiguration
extends NamespacedYamlConfiguration
implements MappingConfiguration {
    private static final Logger log = LoggerFactory.getLogger(YamlMappingConfiguration.class);
    List<MappingEntry> entries = Lists.newArrayList();
    private String xpathVersion = "2.0";
    private int version;
    private String name = "<unnamed>";
    private XPathFactory xpathFactory;
    private Optional<XPathExpression> applicabilityExpression = Optional.empty();
    private String type = "record";
    private String index = "elasticsearch";
    private boolean indexCreationEnabled = false;
    private boolean dynamicMappingEnabled;
    private Optional<String> indexCreationRequest = Optional.empty();
    private final XPathHelper xpathHelper;
    private String identifierField;
    private Optional<String> locationField = Optional.empty();

    public YamlMappingConfiguration(String fileName, XPathHelper xpathHelper) throws IOException {
        this(Resources.asByteSource((URL)Resources.getResource((String)fileName)).openStream(), xpathHelper);
        log.info("Created configuration from filename {}", (Object)fileName);
    }

    public YamlMappingConfiguration(InputStream input, XPathHelper xpathHelper) {
        this.xpathHelper = xpathHelper;
        this.xpathFactory = xpathHelper.newXPathFactory();
        Yaml yaml = new Yaml();
        YamlNode configurationNodes = yaml.load(input);
        if (configurationNodes == null) {
            log.error("Could not load configuration from {}, nodes: {}", (Object)input, (Object)configurationNodes);
        } else {
            log.trace("Read configuration file with the root elements {}", (Object)Joiner.on((String)" ").join((Iterable)configurationNodes));
            NamespaceContext nsContext = this.parseNamespaceContext(configurationNodes);
            this.init(configurationNodes, nsContext);
        }
        log.info("Created configuration from stream {} with {} entries", (Object)input, (Object)this.entries.size());
    }

    private void init(YamlNode configurationNodes, NamespaceContext nsContext) {
        this.name = configurationNodes.path("name").asTextValue("<unnamed>");
        this.version = configurationNodes.path("version").asIntValue(1);
        this.xpathVersion = configurationNodes.path("xpathversion").asTextValue("2.0");
        if (configurationNodes.hasNotNull("index")) {
            YamlNode indexField = configurationNodes.get("index");
            this.index = indexField.path("name").asTextValue("elasticsearch");
            this.indexCreationEnabled = indexField.path("create").asBooleanValue(false);
            this.dynamicMappingEnabled = indexField.path("dynamic_mapping").asBooleanValue(false);
            this.type = indexField.path("type").asTextValue("record");
            if (indexField.hasNotNull("settings")) {
                this.indexCreationRequest = Optional.of(indexField.get("settings").asTextValue());
            }
        }
        if (!this.xpathHelper.isVersionSupported(this.xpathFactory, this.xpathVersion)) {
            throw new MappingError("Provided factory {} does not support version {}", this.xpathFactory, this.xpathVersion);
        }
        log.debug("Using XPathFactory {}", (Object)this.xpathFactory);
        String applicabilityXPathString = configurationNodes.path("applicability_xpath").asTextValue("true()");
        XPath path = this.newXPath(nsContext);
        try {
            this.applicabilityExpression = Optional.of(path.compile(applicabilityXPathString));
        }
        catch (XPathExpressionException e) {
            log.error("Could not compile applicability xpath, will always evalute to true", (Throwable)e);
        }
        if (configurationNodes.hasNotNull("mappings")) {
            YamlMapNode mappingsNode = configurationNodes.path("mappings").asMap();
            this.entries = Lists.newArrayList();
            for (Map.Entry entry : mappingsNode.entries()) {
                MappingEntry e = this.createEntry(((YamlNode)entry.getKey()).asTextValue(), (YamlNode)entry.getValue(), nsContext);
                log.trace("Created entry: {}", (Object)e);
                this.entries.add(e);
            }
            long idCount = this.entries.stream().filter(MappingEntry::isIdentifier).count();
            if (idCount > 1L) {
                List entriesWithId = this.entries.stream().filter(MappingEntry::isIdentifier).map(MappingEntry::getFieldName).collect(Collectors.toList());
                log.error("Found more than one entries marked as 'identifier': {}", (Object)Arrays.toString(entriesWithId.toArray()));
                throw new MappingError("More than one field are marked as 'identifier'. Found {}: {}", idCount, Arrays.toString(entriesWithId.toArray()));
            }
            Optional<MappingEntry> identifier = this.entries.stream().filter(MappingEntry::isIdentifier).findFirst();
            if (!identifier.isPresent()) {
                throw new MappingError("No field is marked as 'identifier', exactly one must be.", new Object[0]);
            }
            this.identifierField = identifier.get().getFieldName();
            log.trace("Found identifier field '{}'", (Object)this.identifierField);
            long locationCount = this.entries.stream().filter(MappingEntry::isLocation).count();
            if (locationCount > 1L) {
                List entriesWithLocation = this.entries.stream().filter(MappingEntry::isIdentifier).map(MappingEntry::getFieldName).collect(Collectors.toList());
                log.error("Found more than one entries marked as 'location': {}", (Object)Arrays.toString(entriesWithLocation.toArray()));
                throw new MappingError("More than one field are marked as 'location'. Found {}: {}", idCount, Arrays.toString(entriesWithLocation.toArray()));
            }
            Optional<MappingEntry> location = this.entries.stream().filter(MappingEntry::isLocation).findFirst();
            if (location.isPresent()) {
                this.locationField = Optional.of(location.get().getFieldName());
                log.trace("Found location field '{}'", (Object)this.locationField.get());
            } else {
                log.warn("No field is marked as 'location'.");
            }
            Collections.sort(this.entries, (me1, me2) -> me1.getFieldName().compareTo(me2.getFieldName()));
        }
    }

    private MappingEntry createEntry(String id, YamlNode node, NamespaceContext nsContext) throws MappingError {
        log.trace("Parsing mapping '{}'", (Object)id);
        if (node instanceof YamlMapNode) {
            YamlMapNode mapNode = (YamlMapNode)node;
            Map<String, Object> indexProperties = this.createIndexProperties(id, node);
            boolean isIdentifier = mapNode.path("identifier").asBooleanValue(false);
            boolean isLocation = mapNode.path("location").asBooleanValue(false);
            boolean isXml = mapNode.path("raw_xml").asBooleanValue(false);
            String expression = mapNode.path("xpath").asTextValue();
            XPath xPath = this.newXPath(nsContext);
            try {
                YamlSeqNode rMap;
                XPathExpression compiledExpression = xPath.compile(expression);
                MappingEntryImpl entry = new MappingEntryImpl(compiledExpression, indexProperties, isIdentifier, isLocation, isXml);
                log.trace("Starting new entry: {}", (Object)entry);
                if (mapNode.hasNotNull("coordinates")) {
                    String coordsType = mapNode.path("coordinates_type").asTextValue();
                    boolean points = mapNode.path("coordinates").has("points");
                    if (coordsType == null || !points) {
                        log.error("Missing properties for field {} for coordinates type: coordinates_type = {}, coordinates.points contained = {}", new Object[]{entry.getFieldName(), coordsType, points});
                        throw new MappingError("Missing properties in field %s for coordinates type: coordinates_type = %s, coordinatesEyxpression = %s, coordinates contained = {}", entry.getFieldName(), coordsType, points);
                    }
                    YamlSeqNode pointsMap = (YamlSeqNode)mapNode.path("coordinates").path("points");
                    List<XPathExpression[]> pointExpressions = pointsMap.value().stream().filter(n -> n instanceof YamlMapNode).map(n -> (YamlMapNode)n).map(mn -> {
                        String expressionStringLat = mn.path("lat").asTextValue();
                        String expressionStringLon = mn.path("lon").asTextValue();
                        try {
                            XPathExpression compiledLat = this.newXPath(nsContext).compile(expressionStringLat);
                            XPathExpression compiledLon = this.newXPath(nsContext).compile(expressionStringLon);
                            return new XPathExpression[]{compiledLat, compiledLon};
                        }
                        catch (XPathExpressionException e) {
                            log.warn("Error creating xpath '{}' or '{}' for point in field {}: {}", new Object[]{expressionStringLat, expressionStringLon, id, e.getMessage()});
                            return null;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    log.trace("Created {} points for {}", (Object)pointExpressions.size(), (Object)id);
                    entry.setCoordinatesXPaths(pointExpressions).setCoordinatesType(coordsType);
                }
                if (mapNode.hasNotNull("replacements")) {
                    rMap = (YamlSeqNode)mapNode.path("replacements");
                    HashMap replacements = Maps.newHashMap();
                    rMap.value().stream().filter(n -> n instanceof YamlMapNode).map(n -> (YamlMapNode)n).map(mn -> {
                        String replace = mn.path("replace").asTextValue();
                        String with = mn.path("with").asTextValue();
                        return new String[]{replace, with};
                    }).forEach(e -> replacements.put(e[0], e[1]));
                    log.trace("Parsed replacements: {}", (Object)Arrays.toString(replacements.entrySet().toArray()));
                    entry.setReplacements(replacements);
                }
                if (mapNode.hasNotNull("split")) {
                    YamlNode sNode = mapNode.path("split");
                    String split = sNode.asTextValue();
                    log.trace("Parsed split: {}", (Object)split);
                    entry.setSplit(split);
                }
                if (mapNode.hasNotNull("output_properties")) {
                    rMap = (YamlSeqNode)mapNode.path("output_properties");
                    HashMap op = Maps.newHashMap();
                    rMap.value().stream().filter(n -> n instanceof YamlMapNode).map(n -> (YamlMapNode)n).map(mn -> {
                        String replace = mn.path("name").asTextValue();
                        String with = mn.path("value").asTextValue();
                        return new String[]{replace, with};
                    }).forEach(e -> op.put(e[0], e[1]));
                    log.trace("Parsed outputProperties: {}", (Object)Arrays.toString(op.entrySet().toArray()));
                    entry.setOutputProperties(op);
                }
                return entry;
            }
            catch (XPathExpressionException e2) {
                log.error("Could not create XPath for provided expression '{}' in field {}", new Object[]{expression, id, e2});
                throw new MappingError(e2, "Could not create XPath for provided expression '%s' in field %s", expression, id);
            }
        }
        throw new MappingError("The provided node class %s is not supported in the mapping '%s': %s", node.getClass().toString(), id, node.toString());
    }

    private XPath newXPath(NamespaceContext nsContext) {
        XPath xPath = this.xpathFactory.newXPath();
        xPath.setNamespaceContext(nsContext);
        return xPath;
    }

    private Map<String, Object> createIndexProperties(String id, YamlNode node) {
        Object nameObj;
        HashMap props = Maps.newHashMap();
        if (node.hasNotNull("properties")) {
            YamlMapNode valueMap = node.path("properties").asMap();
            Map<YamlNode, YamlNode> indexProperties = valueMap.entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            indexProperties.forEach((k, v) -> {
                log.trace("Adding property {} = {}, type: {}", new Object[]{k, v, v.getClass()});
                String key = k.asTextValue();
                Optional<Object> value = Optional.empty();
                if (v instanceof YamlBooleanNode) {
                    value = Optional.of(v.asBooleanValue());
                } else if (v instanceof YamlTextNode) {
                    value = Optional.of(v.asTextValue());
                } else if (v instanceof YamlDecimalNode) {
                    value = Optional.of(v.asDoubleValue());
                } else if (v instanceof YamlIntegralNode) {
                    value = Optional.of(v.asLongValue());
                }
                if (value.isPresent()) {
                    props.put(key, value.get());
                } else {
                    log.error("Could not parse property {}={} because of unhandled type {}", new Object[]{k, v, v.getClass()});
                }
            });
        }
        if (props.containsKey("index_name") && !((nameObj = props.get("index_name")) instanceof String)) {
            log.debug("Index name '{}' of field {} is not a string, falling back to id!", (Object)this.name, (Object)id);
            props.put("index_name", id);
        }
        if (!props.containsKey("type")) {
            props.put("type", "string");
        }
        if (!props.containsKey("index_name")) {
            props.put("index_name", id);
        }
        return props;
    }

    @Override
    public Collection<MappingEntry> getEntries() {
        return this.entries;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getXPathVersion() {
        return this.xpathVersion;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getIndex() {
        return this.index;
    }

    @Override
    public boolean isApplicable(Document doc) {
        boolean result;
        if (!this.applicabilityExpression.isPresent()) {
            log.debug("No applicability xpath provided, returning TRUE.");
            return true;
        }
        try {
            XPathExpression expr = this.applicabilityExpression.get();
            result = (Boolean)expr.evaluate(doc, XPathConstants.BOOLEAN);
        }
        catch (RuntimeException | XPathExpressionException e) {
            log.warn("Error executing applicability xpath on document, returning false: {}", (Object)doc, (Object)e);
            return false;
        }
        return result;
    }

    @Override
    public boolean isIndexCreationEnabled() {
        return this.indexCreationEnabled;
    }

    @Override
    public boolean isDynamicMappingEnabled() {
        return this.dynamicMappingEnabled;
    }

    @Override
    public boolean hasIndexCreationRequest() {
        return this.indexCreationRequest.isPresent();
    }

    @Override
    public String getIndexCreationRequest() {
        return this.indexCreationRequest.get();
    }

    @Override
    public MappingEntry getEntry(String name) {
        return this.entries.stream().filter(e -> e.getFieldName().equals(name)).findFirst().get();
    }

    @Override
    public String getIdentifierField() {
        return this.identifierField;
    }

    @Override
    public boolean hasLocationField() {
        return this.locationField.isPresent();
    }

    @Override
    public String getLocationField() {
        return this.locationField.get();
    }

    public String toString() {
        MoreObjects.ToStringHelper s = MoreObjects.toStringHelper((Object)this).add("version", this.version).add("index", (Object)this.index).add("name", (Object)this.name).add("type", (Object)this.type).add("XPath version", (Object)this.xpathVersion);
        if (this.applicabilityExpression.isPresent()) {
            s.add("applicability", (Object)this.applicabilityExpression.get());
        }
        return s.omitNullValues().toString();
    }
}

