/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.harvest;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import net.opengis.csw.v_2_0_2.AbstractRecordType;
import org.n52.youngs.api.Report;
import org.n52.youngs.harvest.Source;
import org.n52.youngs.harvest.SourceRecord;
import org.n52.youngs.impl.ContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class CswSource
implements Source {
    private static final Logger log = LoggerFactory.getLogger(CswSource.class);
    private final URL url;
    protected Optional<Long> recordCount = Optional.empty();
    private String typeNames;
    private Optional<String> namespacesParameter = Optional.empty();
    Optional<Collection<String>> namespaces = Optional.empty();
    private String outputSchema;
    protected JAXBContext context;
    protected Unmarshaller unmarshaller;
    private NamespaceContext namespaceContext;

    public CswSource(String url, NamespaceContext nsContext) throws MalformedURLException, JAXBException {
        this(url, (Collection<String>)DEFAULT_NAMESPACES, nsContext, "csw:Record", "http://www.opengis.net/cat/csw/2.0.2");
    }

    public CswSource(String url, Collection<String> namespaces, NamespaceContext nsContext, String typeName, String outputSchema) throws MalformedURLException, JAXBException {
        this(new URL(url), namespaces, nsContext, typeName, outputSchema);
    }

    public CswSource(URL url, String namespacesParameter, String typeName, String outputSchema) throws JAXBException {
        this.url = url;
        this.typeNames = typeName;
        this.namespacesParameter = Optional.of(namespacesParameter);
        this.outputSchema = outputSchema;
        this.init();
    }

    public CswSource(URL url, Collection<String> namespaces, NamespaceContext nsContext, String typeName, String outputSchema) throws JAXBException {
        this.url = url;
        this.typeNames = typeName;
        this.namespaces = Optional.of(namespaces);
        this.outputSchema = outputSchema;
        this.namespaceContext = nsContext;
        this.init();
    }

    private void init() throws JAXBException {
        this.context = ContextHelper.getContextForNamespace(this.outputSchema);
        this.unmarshaller = this.context.createUnmarshaller();
    }

    @Override
    public URL getEndpoint() {
        return this.url;
    }

    @Override
    public long getRecordCount() {
        return this.recordCount.orElseGet(this.getAndStoreRecordCount());
    }

    @Override
    public Collection<SourceRecord> getRecords(Report report) {
        return this.getRecords(1L, Long.MAX_VALUE, report);
    }

    @Override
    public abstract Collection<SourceRecord> getRecords(long var1, long var3, Report var5);

    protected abstract Supplier<? extends Long> getAndStoreRecordCount();

    protected Node getNode(JAXBElement<? extends AbstractRecordType> record, JAXBContext context, DocumentBuilder db) {
        try {
            Document document = db.newDocument();
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal(record, (Node)document);
            Element elem = document.getDocumentElement();
            return elem;
        }
        catch (JAXBException e) {
            log.warn("Error getting node from record {}: {} > {}", new Object[]{record, e, e.getMessage()});
            return null;
        }
    }

    protected String getNamespacesParameter() {
        return this.namespacesParameter.orElseGet(new NamespacesParameterSupplier(this.namespaces.orElse(DEFAULT_NAMESPACES), this.namespaceContext));
    }

    protected String getTypeNamesParameter() {
        return this.typeNames;
    }

    public String getOutputSchemaParameter() {
        return this.outputSchema;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("url", (Object)this.getEndpoint()).omitNullValues().toString();
    }

    private class NamespacesParameterSupplier
    implements Supplier<String> {
        private final Collection<String> namespaces;
        private final NamespaceContext namespaceContext;

        public NamespacesParameterSupplier(Collection<String> namespaces, NamespaceContext namespaceContext) {
            this.namespaces = namespaces;
            this.namespaceContext = namespaceContext;
        }

        @Override
        public String get() {
            StringBuilder sb = new StringBuilder();
            sb.append("xmlns(");
            ImmutableMap ns = Maps.uniqueIndex(this.namespaces, this.namespaceContext::getPrefix);
            Joiner.on((String)";").withKeyValueSeparator("=").appendTo(sb, (Map)ns);
            sb.append(")");
            return sb.toString();
        }
    }
}

