/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.harvest;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.opengis.csw.v_2_0_2.AbstractRecordType;
import net.opengis.csw.v_2_0_2.GetRecordsResponseType;
import org.apache.http.client.fluent.Request;
import org.n52.youngs.api.Report;
import org.n52.youngs.harvest.CswSource;
import org.n52.youngs.harvest.NodeSourceRecord;
import org.n52.youngs.harvest.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class KvpCswSource
extends CswSource {
    private static final Logger log = LoggerFactory.getLogger(KvpCswSource.class);
    private static final Joiner.MapJoiner urlParameterJoiner = Joiner.on((String)"&").withKeyValueSeparator("=");

    public KvpCswSource(String url, NamespaceContext nsContext) throws MalformedURLException, JAXBException {
        super(url, nsContext);
    }

    public KvpCswSource(String url, Collection<String> namespaces, NamespaceContext nsContext, String typeName, String outputSchema) throws MalformedURLException, JAXBException {
        super(url, namespaces, nsContext, typeName, outputSchema);
    }

    public KvpCswSource(URL url, String namespacesParameter, String typeName, String outputSchema) throws JAXBException {
        super(url, namespacesParameter, typeName, outputSchema);
    }

    public KvpCswSource(URL url, Collection<String> namespaces, NamespaceContext nsContext, String typeName, String outputSchema) throws JAXBException {
        super(url, namespaces, nsContext, typeName, outputSchema);
    }

    @Override
    public Collection<SourceRecord> getRecords(long startPosition, long maxRecords, Report report) {
        log.debug("Requesting {} records from catalog starting at {}", (Object)maxRecords, (Object)startPosition);
        ArrayList records = Lists.newArrayList();
        String recordsRequest = this.createRequest(startPosition, maxRecords);
        log.trace("GetRecords request: {}", (Object)recordsRequest);
        try {
            List jaxb_records;
            InputStream response = Request.Get((String)recordsRequest).execute().returnContent().asStream();
            JAXBElement jaxb_response = this.unmarshaller.unmarshal((Source)new StreamSource(response), GetRecordsResponseType.class);
            BigInteger numberOfRecordsReturned = ((GetRecordsResponseType)jaxb_response.getValue()).getSearchResults().getNumberOfRecordsReturned();
            log.debug("Got response with {} records", (Object)numberOfRecordsReturned);
            List nodes = ((GetRecordsResponseType)jaxb_response.getValue()).getSearchResults().getAny();
            if (!nodes.isEmpty()) {
                log.trace("Found {} \"any\" nodes.", (Object)nodes.size());
                nodes.stream().filter(n -> n instanceof Node).map(n -> (Node)n).map(n -> new NodeSourceRecord((Node)n)).forEach(records::add);
            }
            if (!(jaxb_records = ((GetRecordsResponseType)jaxb_response.getValue()).getSearchResults().getAbstractRecord()).isEmpty()) {
                log.trace("Found {} \"AbstractRecordType\" records.", (Object)jaxb_records.size());
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                jaxb_records.stream().map(type -> this.getNode((JAXBElement<? extends AbstractRecordType>)type, this.context, db)).filter(Objects::nonNull).map(n -> new NodeSourceRecord((Node)n)).forEach(records::add);
            }
        }
        catch (IOException | JAXBException | ParserConfigurationException e) {
            log.error("Could not retrieve records using url {}", (Object)recordsRequest, (Object)e);
            report.addMessage(String.format("Error retrieving record from endpoint %s: %s", this, e));
        }
        return records;
    }

    private String createRequest(long startPosition, long maxRecords) {
        StringBuilder recordsRequest = new StringBuilder();
        URL url = this.getEndpoint();
        recordsRequest.append(url);
        if (!url.toString().endsWith("?")) {
            recordsRequest.append("?");
        }
        String fixedParameters = urlParameterJoiner.join((Map)ImmutableMap.of((Object)"service", (Object)"CSW", (Object)"version", (Object)"2.0.2", (Object)"request", (Object)"GetRecords", (Object)"resultType", (Object)"results", (Object)"ElementSetName", (Object)"full"));
        recordsRequest.append(fixedParameters);
        String parameters = urlParameterJoiner.join((Map)ImmutableMap.of((Object)"namespace", (Object)this.getNamespacesParameter(), (Object)"typeNames", (Object)this.getTypeNamesParameter(), (Object)"outputSchema", (Object)this.getOutputSchemaParameter(), (Object)"startPosition", (Object)startPosition, (Object)"maxRecords", (Object)maxRecords));
        recordsRequest.append("&").append(parameters);
        return recordsRequest.toString();
    }

    @Override
    protected Supplier<? extends Long> getAndStoreRecordCount() {
        CswRecordCountSupplier s = new CswRecordCountSupplier();
        this.recordCount = Optional.of(s.get());
        return s;
    }

    private class CswRecordCountSupplier
    implements Supplier<Long> {
        @Override
        public Long get() {
            URL url = KvpCswSource.this.getEndpoint();
            log.debug("Requesting record count at {} using {} and {}", new Object[]{url, KvpCswSource.this.getTypeNamesParameter(), KvpCswSource.this.getNamespacesParameter()});
            Long count = Long.MIN_VALUE;
            StringBuilder hitsRequest = new StringBuilder();
            hitsRequest.append(url);
            if (!url.toString().endsWith("?")) {
                hitsRequest.append("?");
            }
            String fixedParameters = urlParameterJoiner.join((Map)ImmutableMap.of((Object)"service", (Object)"CSW", (Object)"version", (Object)"2.0.2", (Object)"request", (Object)"GetRecords", (Object)"resultType", (Object)"hits", (Object)"ElementSetName", (Object)"summary"));
            hitsRequest.append(fixedParameters);
            String parameters = urlParameterJoiner.join((Map)ImmutableMap.of((Object)"namespace", (Object)KvpCswSource.this.getNamespacesParameter(), (Object)"typeNames", (Object)KvpCswSource.this.getTypeNamesParameter()));
            hitsRequest.append("&").append(parameters);
            try {
                InputStream response = Request.Get((String)hitsRequest.toString()).execute().returnContent().asStream();
                GetRecordsResponseType getRecordsResponse = (GetRecordsResponseType)KvpCswSource.this.unmarshaller.unmarshal((Source)new StreamSource(response), GetRecordsResponseType.class).getValue();
                BigInteger numberOfRecordsMatched = getRecordsResponse.getSearchResults().getNumberOfRecordsMatched();
                count = numberOfRecordsMatched.longValue();
                log.debug("Found {} records", (Object)count);
            }
            catch (IOException | JAXBException e) {
                log.error("Could not retrieve record count using url {}", (Object)hitsRequest, (Object)e);
            }
            return count;
        }
    }
}

