/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.harvest;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.opengis.csw.v_2_0_2.AbstractRecordType;
import net.opengis.csw.v_2_0_2.ElementSetNameType;
import net.opengis.csw.v_2_0_2.ElementSetType;
import net.opengis.csw.v_2_0_2.GetRecordsResponseType;
import net.opengis.csw.v_2_0_2.GetRecordsType;
import net.opengis.csw.v_2_0_2.ObjectFactory;
import net.opengis.csw.v_2_0_2.QueryType;
import net.opengis.csw.v_2_0_2.ResultType;
import org.apache.http.HttpEntity;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.n52.youngs.api.Report;
import org.n52.youngs.harvest.CswSource;
import org.n52.youngs.harvest.NodeSourceRecord;
import org.n52.youngs.harvest.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PoxCswSource
extends CswSource {
    private static final Logger log = LoggerFactory.getLogger(PoxCswSource.class);
    private Optional<Marshaller> marshaller = Optional.empty();

    public PoxCswSource(URL url, Collection<String> namespaces, NamespaceContext nsContext, String typeName, String outputSchema) throws JAXBException {
        super(url, namespaces, nsContext, typeName, outputSchema);
    }

    @Override
    public Collection<SourceRecord> getRecords(long startPosition, long maxRecords, Report report) {
        log.debug("Requesting {} records from catalog starting at {}", (Object)maxRecords, (Object)startPosition);
        ArrayList records = Lists.newArrayList();
        HttpEntity entity = this.createRequest(startPosition, maxRecords);
        try {
            List jaxb_records;
            log.debug("GetRecords request: {}", (Object)EntityUtils.toString((HttpEntity)entity));
            String response = Request.Post((String)this.getEndpoint().toString()).body(entity).addHeader("Content-Type", ContentType.APPLICATION_XML.getMimeType()).execute().returnContent().asString();
            log.trace("Response: {}", (Object)response);
            JAXBElement jaxb_response = this.unmarshaller.unmarshal((Source)new StreamSource(new StringReader(response)), GetRecordsResponseType.class);
            BigInteger numberOfRecordsReturned = ((GetRecordsResponseType)jaxb_response.getValue()).getSearchResults().getNumberOfRecordsReturned();
            log.debug("Got response with {} records", (Object)numberOfRecordsReturned);
            List nodes = ((GetRecordsResponseType)jaxb_response.getValue()).getSearchResults().getAny();
            if (!nodes.isEmpty()) {
                log.debug("Found {} \"any\" nodes.", (Object)nodes.size());
                nodes.stream().filter(n -> n instanceof Node).map(n -> (Node)n).map(n -> new NodeSourceRecord((Node)n)).forEach(records::add);
            }
            if (!(jaxb_records = ((GetRecordsResponseType)jaxb_response.getValue()).getSearchResults().getAbstractRecord()).isEmpty()) {
                log.debug("Found {} \"AbstractRecordType\" records.", (Object)jaxb_records.size());
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                jaxb_records.stream().map(type -> this.getNode((JAXBElement<? extends AbstractRecordType>)type, this.context, db)).filter(Objects::nonNull).map(n -> new NodeSourceRecord((Node)n)).forEach(records::add);
            }
        }
        catch (IOException | JAXBException | ParserConfigurationException e) {
            log.error("Could not retrieve records from endpoint {}", (Object)this.getEndpoint(), (Object)e);
            report.addMessage(String.format("Error retrieving record from endpoint %s: %s", this, e));
        }
        log.debug("Decoded {} records", (Object)records.size());
        return records;
    }

    @Override
    protected Supplier<? extends Long> getAndStoreRecordCount() {
        CswRecordCountSupplier s = new CswRecordCountSupplier();
        if (!this.recordCount.isPresent()) {
            this.recordCount = Optional.of(s.get());
        }
        return s;
    }

    private Marshaller getMarshaller() throws JAXBException {
        if (!this.marshaller.isPresent()) {
            this.marshaller = Optional.of(this.context.createMarshaller());
            this.marshaller.get().setProperty("jaxb.formatted.output", (Object)true);
        }
        return this.marshaller.get();
    }

    private HttpEntity createRequest(long startPosition, long maxRecords) {
        Marshaller m;
        try {
            m = this.getMarshaller();
        }
        catch (JAXBException e) {
            log.error("Could not create marshaller", (Throwable)e);
            return null;
        }
        GetRecordsType getRecords = new GetRecordsType();
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement jaxb_getRecords = objectFactory.createGetRecords(getRecords);
        getRecords.setResultType(ResultType.RESULTS);
        getRecords.setOutputSchema(this.getOutputSchemaParameter());
        getRecords.setStartPosition(BigInteger.valueOf(startPosition));
        getRecords.setMaxRecords(BigInteger.valueOf(maxRecords));
        QueryType query = new QueryType();
        ElementSetNameType esn = new ElementSetNameType();
        esn.setValue(ElementSetType.FULL);
        query.setElementSetName(esn);
        query.setTypeNames((List)Lists.newArrayList((Object[])new QName[]{new QName(this.getOutputSchemaParameter(), this.getTypeNamesParameter().substring(this.getTypeNamesParameter().indexOf(":") + 1))}));
        getRecords.setAbstractQuery(objectFactory.createQuery(query));
        StringWriter w = new StringWriter();
        try {
            m.marshal((Object)jaxb_getRecords, (Writer)w);
        }
        catch (JAXBException e) {
            log.error("Error marshalling request", (Throwable)e);
        }
        log.trace("Created GetRecords request starting at {} for {} records:\n{}", new Object[]{startPosition, maxRecords, ((Object)w).toString()});
        StringEntity entity = new StringEntity(((Object)w).toString(), Charsets.UTF_8);
        return entity;
    }

    private class CswRecordCountSupplier
    implements Supplier<Long> {
        @Override
        public Long get() {
            Marshaller m;
            URL url = PoxCswSource.this.getEndpoint();
            String tn = PoxCswSource.this.getTypeNamesParameter();
            String os = PoxCswSource.this.getOutputSchemaParameter();
            log.debug("Requesting record count at {} using typenames {}, output schema {}", new Object[]{url, tn, os});
            Long count = Long.MIN_VALUE;
            try {
                m = PoxCswSource.this.getMarshaller();
            }
            catch (JAXBException e) {
                log.error("Could not create marshaller", (Throwable)e);
                return count;
            }
            GetRecordsType getRecords = new GetRecordsType();
            ObjectFactory objectFactory = new ObjectFactory();
            JAXBElement jaxb_getRecords = objectFactory.createGetRecords(getRecords);
            getRecords.setResultType(ResultType.HITS);
            getRecords.setOutputSchema(os);
            QueryType query = new QueryType();
            ElementSetNameType esn = new ElementSetNameType();
            esn.setValue(ElementSetType.FULL);
            query.setElementSetName(esn);
            QName qn = new QName(os, tn.substring(tn.indexOf(":") + 1));
            query.setTypeNames((List)Lists.newArrayList((Object[])new QName[]{qn}));
            getRecords.setAbstractQuery(objectFactory.createQuery(query));
            StringWriter w = new StringWriter();
            try {
                m.marshal((Object)jaxb_getRecords, (Writer)w);
            }
            catch (JAXBException e) {
                log.error("Error marshalling request", (Throwable)e);
            }
            log.debug("Sending GetRecords request:\n{}", (Object)((Object)w).toString());
            try {
                InputStream response = Request.Post((String)PoxCswSource.this.getEndpoint().toString()).bodyString(((Object)w).toString(), ContentType.APPLICATION_XML).execute().returnContent().asStream();
                GetRecordsResponseType getRecordsResponse = (GetRecordsResponseType)PoxCswSource.this.unmarshaller.unmarshal((Source)new StreamSource(response), GetRecordsResponseType.class).getValue();
                BigInteger numberOfRecordsMatched = getRecordsResponse.getSearchResults().getNumberOfRecordsMatched();
                count = numberOfRecordsMatched.longValue();
                log.debug("Found {} records", (Object)count);
            }
            catch (IOException | JAXBException e) {
                log.error("Could not retrieve record count using request {}", (Object)((Object)w).toString(), (Object)e);
            }
            return count;
        }
    }
}

