/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Map;
import org.n52.youngs.api.Report;

public class ReportImpl
implements Report {
    private final Collection<String> added = Lists.newArrayList();
    private final Map<String, String> failed = Maps.newHashMap();
    private final Map<LocalTime, String> messages = Maps.newHashMap();

    @Override
    public int getNumberOfRecordsAdded() {
        return this.added.size();
    }

    @Override
    public int getNumberOfRecordsFailed() {
        return this.failed.size();
    }

    @Override
    public void addSuccessfulRecord(String id) {
        this.added.add(id);
    }

    @Override
    public void addFailedRecord(String id, String reason) {
        this.failed.put(id, reason);
    }

    public void addFailedRecord(String id) {
        this.failed.put(id, "");
    }

    @Override
    public Collection<String> getAddedIds() {
        return this.added;
    }

    @Override
    public Map<String, String> getFailedIds() {
        return this.failed;
    }

    @Override
    public void addMessage(String message) {
        this.messages.put(LocalTime.now(), message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("### Report ###\n");
        sb.append(" Added: ").append(this.getNumberOfRecordsAdded()).append("\n");
        sb.append(" Failed: ").append(this.getNumberOfRecordsFailed()).append("\n").append("\n");
        sb.append(" Added IDs: ").append(Joiner.on((String)", ").join(this.added)).append("\n");
        sb.append(" Faild IDs: ").append(Joiner.on((String)", ").withKeyValueSeparator(": ").join(this.failed)).append("\n");
        sb.append(" Messages: ").append(Joiner.on((String)"; ").withKeyValueSeparator(": ").join(this.messages)).append("\n");
        return sb.toString();
    }
}

