/*
 * Copyright 2015-2019 52°North Initiative for Geospatial Open Source
 * Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.youngs.harvest;

import org.w3c.dom.Node;

/**
 * @author <a href="mailto:d.nuest@52north.org">Daniel Nüst</a>
 */
public class NodeSourceRecord implements SourceRecord {

    private final Node record;
    private final String protocolIdentifier;

    public NodeSourceRecord(Node record, String protocolIdentifier) {
        this.record = record;
        this.protocolIdentifier = protocolIdentifier;
    }

    public Node getRecord() {
        return this.record;
    }

    @Override
    public String getProtocolIdentifier() {
        return protocolIdentifier;
    }

}
