/*
 * Copyright 2015-2019 52°North Initiative for Geospatial Open Source
 * Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.youngs.load.impl;

import org.n52.iceland.statistics.api.mappings.MetadataDataMapping;
import org.n52.iceland.statistics.api.parameters.AbstractEsParameter;
import org.n52.iceland.statistics.api.parameters.Description;
import org.n52.iceland.statistics.api.parameters.ElasticsearchTypeRegistry;
import org.n52.iceland.statistics.api.parameters.SingleEsParameter;

/**
 * @see MetadataDataMapping
 *
 * @author <a href="mailto:d.nuest@52north.org">Daniel Nüst</a>
 */
public class YoungsMetadataDataMapping {

    public static final AbstractEsParameter METADATA_NAME_FIELD = new SingleEsParameter("mt-name", new Description(
            Description.InformationOrigin.None, Description.Operation.Metadata, "Name of the used metadata type"), ElasticsearchTypeRegistry.stringField);

}
