/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.harvest;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import org.n52.youngs.exception.SourceError;
import org.n52.youngs.harvest.InputStreamSource;

public class FileSource
extends InputStreamSource {
    private final Path file;
    private DocumentBuilderFactory docBuilderFactory;

    public FileSource(Path file) {
        Objects.requireNonNull(file);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IllegalStateException("File does not exist: " + file);
        }
        this.file = file;
        this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.docBuilderFactory.setNamespaceAware(true);
    }

    @Override
    public URL getEndpoint() {
        try {
            return this.file.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new SourceError(e, "Could not create URL from directory %s", this.file);
        }
    }

    @Override
    protected InputStream resolveSourceInputStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    protected String resolveProtocolIdentifier() {
        return this.file.getFileName().toString();
    }
}

