/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.harvest;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.n52.youngs.harvest.InputStreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryStreamSource
extends InputStreamSource {
    private static final Logger LOG = LoggerFactory.getLogger((String)InMemoryStreamSource.class.getName());
    private final InputStream stream;

    public InMemoryStreamSource(InputStream stream) {
        this.stream = stream;
    }

    @Override
    protected InputStream resolveSourceInputStream() throws IOException {
        return this.stream;
    }

    @Override
    public URL getEndpoint() {
        try {
            return new URL("file:///dev/null");
        }
        catch (MalformedURLException ex) {
            LOG.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    protected String resolveProtocolIdentifier() {
        return "internal-stream";
    }
}

