/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.harvest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.n52.youngs.api.Report;
import org.n52.youngs.harvest.NodeSourceRecord;
import org.n52.youngs.harvest.Source;
import org.n52.youngs.harvest.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class InputStreamSource
implements Source {
    private static final Logger LOG = LoggerFactory.getLogger((String)InputStreamSource.class.getName());
    private final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();

    public InputStreamSource() {
        this.docBuilderFactory.setNamespaceAware(true);
    }

    @Override
    public long getRecordCount() {
        return 1L;
    }

    @Override
    public Collection<SourceRecord> getRecords(Report report) {
        try {
            DocumentBuilder documentBuilder = this.docBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(new InputSource(new InputStreamReader(this.resolveSourceInputStream(), this.sourceCharset())));
            Element elem = doc.getDocumentElement();
            elem.normalize();
            LOG.trace("Read document: {}", (Object)elem);
            NodeSourceRecord record = new NodeSourceRecord(elem, this.resolveProtocolIdentifier());
            return Collections.singletonList(record);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            LOG.warn("Could not read file:" + ex.getMessage(), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    protected abstract InputStream resolveSourceInputStream() throws IOException;

    protected abstract String resolveProtocolIdentifier();

    protected Charset sourceCharset() {
        Charset cs = Charset.forName("utf-8");
        return cs;
    }

    @Override
    public Collection<SourceRecord> getRecords(long startPosition, long maxRecords, Report report) {
        return this.getRecords(report);
    }
}

