/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.harvest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.n52.youngs.api.Report;
import org.n52.youngs.harvest.NodeSourceRecord;
import org.n52.youngs.harvest.Source;
import org.n52.youngs.harvest.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class XmlElementSource
implements Source {
    private static final Logger LOG = LoggerFactory.getLogger((String)XmlElementSource.class.getName());
    private final Element element;

    public XmlElementSource(Element element) {
        Objects.requireNonNull(element);
        this.element = element;
    }

    @Override
    public URL getEndpoint() {
        try {
            return new URL("inmemory://xml");
        }
        catch (MalformedURLException ex) {
            LOG.warn("invalid URL", (Throwable)ex);
            return null;
        }
    }

    @Override
    public long getRecordCount() {
        return 1L;
    }

    @Override
    public Collection<SourceRecord> getRecords(Report report) {
        return Collections.singleton(new NodeSourceRecord(this.element, "internal-xml"));
    }

    @Override
    public Collection<SourceRecord> getRecords(long startPosition, long maxRecords, Report report) {
        return Collections.singleton(new NodeSourceRecord(this.element, "internal-xml"));
    }
}

