/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.impl;

import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.opengis.csw.v_2_0_2.AbstractRecordType;
import net.opengis.csw.v_2_0_2.GetRecordsResponseType;
import org.n52.youngs.harvest.NodeSourceRecord;
import org.n52.youngs.harvest.SourceRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SourceRecordHelper {
    public static Collection<SourceRecord> loadGetRecordsResponse(InputStream input) throws Exception {
        List jaxb_records;
        JAXBContext context = JAXBContext.newInstance((String)"net.opengis.csw.v_2_0_2");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        ArrayList records = Lists.newArrayList();
        JAXBElement jaxb_response = unmarshaller.unmarshal((Source)new StreamSource(input), GetRecordsResponseType.class);
        List nodes = ((GetRecordsResponseType)jaxb_response.getValue()).getSearchResults().getAny();
        if (!nodes.isEmpty()) {
            AtomicInteger streamIndex = new AtomicInteger(0);
            nodes.stream().filter(n -> n instanceof Node).map(n -> (Node)n).map(n -> new NodeSourceRecord((Node)n, "csw-record-" + streamIndex.getAndIncrement())).forEach(records::add);
        }
        if (!(jaxb_records = ((GetRecordsResponseType)jaxb_response.getValue()).getSearchResults().getAbstractRecord()).isEmpty()) {
            AtomicInteger streamIndex = new AtomicInteger(0);
            jaxb_records.stream().map(type -> SourceRecordHelper.getNode((JAXBElement<? extends AbstractRecordType>)type, context)).filter(Objects::nonNull).map(n -> new NodeSourceRecord((Node)n, "csw-record-" + streamIndex.getAndIncrement())).forEach(records::add);
        }
        return records;
    }

    private static Node getNode(JAXBElement<? extends AbstractRecordType> record, JAXBContext context) {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = db.newDocument();
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal(record, (Node)document);
            Element elem = document.getDocumentElement();
            return elem;
        }
        catch (JAXBException | ParserConfigurationException e) {
            System.out.println(String.format("Error getting node from record %s: %s > %s", record, e, e.getMessage()));
            return null;
        }
    }

    public static SourceRecord getSourceRecordFromFile(String filename) throws Exception {
        try (InputStream is = Resources.asByteSource((URL)Resources.getResource((String)filename)).openStream();){
            NodeSourceRecord record;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.parse(is);
            Element elem = doc.getDocumentElement();
            elem.normalize();
            NodeSourceRecord nodeSourceRecord = record = new NodeSourceRecord(elem, filename);
            return nodeSourceRecord;
        }
    }
}

