/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.load.impl;

import com.google.common.io.Files;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.n52.youngs.exception.SinkError;
import org.n52.youngs.load.impl.ElasticsearchSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchRemoteHttpSink
extends ElasticsearchSink {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchRemoteHttpSink.class);
    private final String host;
    private final int port;
    private final Client client;

    public ElasticsearchRemoteHttpSink(String host, int port, String cluster, String index, String type) {
        this(host, port, cluster, index, type, Mode.TRANSPORT);
    }

    public ElasticsearchRemoteHttpSink(String host, int port, String cluster, String index, String type, Mode mode) {
        super(cluster, index, type);
        this.host = host;
        this.port = port;
        Settings.Builder settings = Settings.builder().put("cluster.name", this.getCluster());
        try {
            switch (mode) {
                case TRANSPORT: {
                    PreBuiltTransportClient tClient = new PreBuiltTransportClient(settings.build(), new Class[0]);
                    tClient.addTransportAddress(new TransportAddress(InetAddress.getByName(this.host), this.port));
                    this.client = tClient;
                    break;
                }
                case NODE: {
                    settings.put("http.enabled", false);
                    settings.put("path.home", Files.createTempDir().toPath());
                    Node node = new Node(settings.build());
                    this.client = node.client();
                    break;
                }
                default: {
                    throw new SinkError("Unsupported mode %s", new Object[]{mode});
                }
            }
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
        log.info("Created new client with settings {}:\n{}", (Object)settings, (Object)this.client);
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    public static enum Mode {
        NODE,
        TRANSPORT;

    }
}

