/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.load.impl;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.n52.youngs.load.SchemaGenerator;
import org.n52.youngs.transform.MappingConfiguration;
import org.n52.youngs.transform.MappingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaGeneratorImpl
implements SchemaGenerator {
    private static final Logger log = LoggerFactory.getLogger(SchemaGeneratorImpl.class);

    @Override
    public Map<String, Object> generate(MappingConfiguration mapping) {
        HashMap schema = Maps.newHashMap();
        schema.put("dynamic", mapping.isDynamicMappingEnabled());
        HashMap fields = Maps.newHashMap();
        mapping.getEntries().forEach(entry -> fields.put(entry.getFieldName(), this.createElasticEntry((MappingEntry)entry)));
        if (mapping.hasSuggest()) {
            HashMap<String, Object> suggest = new HashMap<String, Object>(mapping.getSuggest());
            if (suggest.containsKey("mappingConfiguration")) {
                suggest.remove("mappingConfiguration");
            }
            fields.put("suggest", suggest);
        }
        schema.put("properties", fields);
        log.info("Created {} schema with {} fields", (Object)(mapping.isDynamicMappingEnabled() ? "dynamic" : ""), (Object)fields.size());
        log.debug("Created schema with {} first level elements: {}", (Object)schema.size(), (Object)Arrays.deepToString(schema.entrySet().toArray()));
        return schema;
    }

    private Map<String, Object> createElasticEntry(MappingEntry entry) {
        HashMap properties = Maps.newHashMap();
        entry.getIndexProperties().entrySet().stream().forEach(entryProps -> properties.put(entryProps.getKey(), entryProps.getValue()));
        if (this.isNested(entry)) {
            HashMap childrenMap = new HashMap();
            entry.getChildren().stream().forEach(c -> childrenMap.put(c.getFieldName(), this.createElasticEntry((MappingEntry)c)));
            properties.put("properties", childrenMap);
        }
        return properties;
    }

    private boolean isNested(MappingEntry entry) {
        return entry.getIndexProperties().entrySet().stream().filter(e -> ((String)e.getKey()).equals("type") && e.getValue().equals("nested")).count() > 0L;
    }
}

