/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.transform.impl;

import com.google.common.base.MoreObjects;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.n52.youngs.harvest.NodeSourceRecord;
import org.n52.youngs.harvest.SourceRecord;
import org.n52.youngs.load.impl.BuilderRecord;
import org.n52.youngs.transform.Mapper;
import org.n52.youngs.transform.MappingConfiguration;
import org.n52.youngs.transform.MappingEntry;
import org.n52.youngs.transform.impl.EntryMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class CswToBuilderMapper
implements Mapper {
    private static final Logger log = LoggerFactory.getLogger(CswToBuilderMapper.class);
    private final MappingConfiguration mapper;
    private Optional<Transformer> stripspaceTransformer = Optional.empty();
    private Transformer defaultTransformer;

    public CswToBuilderMapper(MappingConfiguration mapper) {
        this.mapper = mapper;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try (InputStream is = Resources.getResource((String)"xslt/stripspace.xslt").openStream();){
            StreamSource xslt = new StreamSource(is);
            this.stripspaceTransformer = Optional.of(tFactory.newTransformer(xslt));
            log.trace("Will apply stripspace XSLT.");
        }
        catch (IOException | TransformerConfigurationException e) {
            log.error("Problem loading strip-space XSLT file.", (Throwable)e);
        }
        try {
            this.defaultTransformer = tFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            log.error("Problem loading deault Transformer.", (Throwable)ex);
        }
    }

    @Override
    public MappingConfiguration getMapper() {
        return this.mapper;
    }

    @Override
    public BuilderRecord map(SourceRecord sourceRecord) {
        Objects.nonNull(sourceRecord);
        BuilderRecord record = null;
        if (sourceRecord instanceof NodeSourceRecord) {
            try {
                NodeSourceRecord object = (NodeSourceRecord)sourceRecord;
                IdAndBuilder mappedRecord = this.mapNodeToBuilder(object.getRecord());
                if (mappedRecord == null) {
                    return null;
                }
                record = new BuilderRecord(mappedRecord.id, mappedRecord.builder);
                return record;
            }
            catch (IOException e) {
                log.warn("Error mapping the source {}", (Object)sourceRecord, (Object)e);
                return null;
            }
        }
        log.warn("The SourceRecord class {} is not supported", (Object)sourceRecord.getClass().getName());
        return record;
    }

    private IdAndBuilder mapNodeToBuilder(Node node) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().humanReadable(true).prettyPrint().startObject();
        Collection<MappingEntry> entries = this.mapper.getEntries();
        log.trace("Mapping node {} using {} entries", (Object)node, (Object)entries.size());
        String id = null;
        try {
            Optional<MappingEntry> idEntry = entries.stream().filter(MappingEntry::isIdentifier).findFirst();
            if (idEntry.isPresent()) {
                id = idEntry.get().getXPath().evaluate(node);
                String string = id = id == null || id.trim().isEmpty() ? null : id.trim();
            }
            if (id == null) {
                log.warn("No ID present, skipping");
                return null;
            }
            log.trace("Found id for node: {}", id);
        }
        catch (XPathExpressionException e2) {
            log.warn("Error selecting id field from node", (Throwable)e2);
        }
        List<EntryMapper.EvalResult> mappedEntries = entries.stream().filter(e -> !e.hasCoordinates() && !e.isRawXml()).map((? super T entry) -> this.mapEntry((MappingEntry)entry, node, builder)).filter(entry -> entry.isPresent()).map((? super T entry) -> (EntryMapper.EvalResult)entry.get()).collect(Collectors.toList());
        mappedEntries.stream().forEach(er -> {
            try {
                Object value = er.value;
                builder.field(er.name);
                builder.value(value);
                log.debug("Added field: {} = {}", (Object)er.name, value instanceof Object[] ? Arrays.toString((Object[])value) : value);
            }
            catch (IOException e) {
                log.warn("Error adding field {}: {}", (Object)er.name, (Object)e);
            }
        });
        entries.stream().filter(e -> e.hasCoordinates() && !e.isRawXml()).forEach(entry -> this.mapSpatialEntry((MappingEntry)entry, node, builder));
        entries.stream().filter(e -> e.isRawXml()).forEach(entry -> this.mapRawEntry((MappingEntry)entry, node, builder));
        if (this.mapper.hasSuggest()) {
            this.handleSuggest(builder, this.mapper.getSuggest(), mappedEntries);
        }
        builder.endObject();
        builder.close();
        log.trace("Created content for id '{}':\n{}", (Object)id, (Object)builder.string());
        return new IdAndBuilder(id, builder);
    }

    private void mapSpatialEntry(MappingEntry entry, Node node, XContentBuilder builder) {
        log.trace("Applying field mapping '{}' to node: {}", (Object)entry.getFieldName(), (Object)node);
        try {
            Object coordsNode = entry.getXPath().evaluate(node, XPathConstants.NODE);
            if (coordsNode != null) {
                String geoType = (String)entry.getIndexPropery("type");
                String field = entry.getFieldName();
                List<XPathExpression[]> pointsXPaths = entry.getCoordinatesXPaths();
                if (!pointsXPaths.isEmpty() && !geoType.isEmpty() && !field.isEmpty() && entry.hasCoordinatesType()) {
                    List pointsDoubles = pointsXPaths.stream().map((? super T p) -> {
                        try {
                            Number lat = (Number)p[0].evaluate(coordsNode, XPathConstants.NUMBER);
                            Number lon = (Number)p[1].evaluate(coordsNode, XPathConstants.NUMBER);
                            return new Number[]{lon, lat};
                        }
                        catch (XPathExpressionException e) {
                            log.warn("Error evaluating XPath {} for coordinate: {}", p, (Object)e);
                            return null;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    log.trace("Evaluated {} expressions and got {} points: {}", new Object[]{pointsXPaths.size(), pointsDoubles.size(), Arrays.deepToString(pointsDoubles.toArray())});
                    builder.startObject(field).field("type", entry.getCoordinatesType()).field("coordinates", pointsDoubles).endObject();
                    log.debug("Added points '{}' as {} of type {}", new Object[]{Arrays.deepToString(pointsDoubles.toArray()), geoType, entry.getCoordinatesType()});
                } else {
                    log.warn("Mapping '{}' has coordinates but is missing one of the other required settings, not adding field: node = {}, index_name = {}, coordinates_type = {}, type = {}, points = {}", new Object[]{entry.getFieldName(), coordsNode, field, entry.getCoordinatesType(), geoType, Arrays.deepToString(pointsXPaths.toArray())});
                }
            } else {
                log.warn("Coords node is null, no result evaluating {} on {]", (Object)entry.getXPath(), (Object)node);
            }
        }
        catch (IOException | XPathExpressionException e) {
            log.warn("Error selecting coordinate-field {} as node. Error was: {}", (Object)entry.getFieldName(), (Object)e.getMessage());
            log.trace("Error selecting field {} as nodeset", (Object)entry.getFieldName(), (Object)e);
        }
    }

    private Optional<EntryMapper.EvalResult> mapEntry(MappingEntry entry, Node node, XContentBuilder builder) {
        Optional<EntryMapper.EvalResult> result = new EntryMapper().mapEntry(entry, node);
        return result;
    }

    private void mapRawEntry(MappingEntry entry, Node node, XContentBuilder builder) {
        try {
            String xmldoc = new EntryMapper(this.stripspaceTransformer, this.defaultTransformer).mapRawEntry(entry, node);
            builder.field(entry.getFieldName(), xmldoc);
        }
        catch (IOException | XPathExpressionException e) {
            log.warn("Error adding field {}: {}", (Object)entry.getFieldName(), (Object)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mapping", (Object)this.mapper).add("defaultTransformer", (Object)this.defaultTransformer).omitNullValues().toString();
    }

    private void handleSuggest(XContentBuilder builder, Map<String, Object> suggestDef, List<EntryMapper.EvalResult> mappingEntries) throws IOException {
        Map suggest = (Map)suggestDef.get("mappingConfiguration");
        ArrayList inputs = new ArrayList();
        Boolean singleWords = this.extractValue(suggest, "input_as_single_words", true);
        String splitSep = this.extractValue(suggest, "split", " ");
        Boolean fullOutput = this.extractValue(suggest, "full_output", true);
        List inputExlucdes = this.extractValue(suggest, "input_exlucdes", Collections.emptyList());
        List inputRemoves = this.extractValue(suggest, "input_remove", Collections.emptyList());
        Integer weight = this.extractValue(suggest, "weight", 1);
        List entries = this.extractValue(suggest, "entries", Collections.emptyList());
        List suggestEntries = entries.stream().map((? super T fieldName) -> {
            Optional<Object> fieldValue = mappingEntries.stream().filter(me -> fieldName.equals(me.getName())).map((? super T me) -> me.getValue()).findFirst();
            if (!fieldValue.isPresent() || !(fieldValue.get() instanceof String)) {
                return null;
            }
            String[] fieldArray = fieldValue.get().toString().split(splitSep);
            List inputList = Arrays.asList(fieldArray).stream().filter(s -> inputExlucdes.stream().noneMatch(ex -> s.equalsIgnoreCase((String)ex) || s.matches((String)ex))).map((? super T s) -> {
                for (String inputRemove : inputRemoves) {
                    s = s.replace(inputRemove, "");
                }
                return s.trim();
            }).collect(Collectors.toList());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("inputs", inputList);
            map.put("weight", weight);
            map.put("output", fieldValue.get());
            return map;
        }).filter(e -> e != null).collect(Collectors.toList());
        if (suggestEntries.isEmpty()) {
            return;
        }
        if (suggestEntries.size() > 1) {
            builder.startArray("suggest");
        } else {
            builder.field("suggest");
        }
        for (Map suggestEntry : suggestEntries) {
            builder.startObject();
            builder.field("input", suggestEntry.get("inputs"));
            builder.field("output", suggestEntry.get("output"));
            builder.field("weight", suggestEntry.get("weight"));
            builder.endObject();
        }
        if (suggestEntries.size() > 1) {
            builder.endArray();
        }
    }

    private <V> V extractValue(Map<String, Object> map, String key, V defaultValue) {
        Object value = map.get(key);
        return (V)(value == null ? defaultValue : value);
    }

    private static class IdAndBuilder {
        protected final String id;
        protected final XContentBuilder builder;

        public IdAndBuilder(String id, XContentBuilder builder) {
            Objects.nonNull(builder);
            this.id = id;
            this.builder = builder;
        }
    }
}

