/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.transform.impl;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.n52.youngs.transform.MappingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EntryMapper {
    private static final Logger log = LoggerFactory.getLogger(EntryMapper.class);
    private static final Map<String, String> DEFAULT_OUTPUT_PROPERTIES = ImmutableMap.of((Object)"omit-xml-declaration", (Object)"no", (Object)"indent", (Object)"no", (Object)"encoding", (Object)Charsets.UTF_8.name());
    private final Optional<Transformer> stripspaceTransformer;
    private final Transformer defaultTransformer;

    public EntryMapper() {
        this(Optional.empty(), null);
    }

    public EntryMapper(Optional<Transformer> stripspaceTransformer, Transformer defaultTransformer) {
        this.stripspaceTransformer = stripspaceTransformer;
        this.defaultTransformer = defaultTransformer;
    }

    public Optional<EvalResult> mapEntry(MappingEntry entry, Node node) {
        log.trace("Applying field mapping '{}' to node: {}", (Object)entry.getFieldName(), (Object)node);
        Optional<Object> result = Optional.empty();
        try {
            if (entry.hasCondition() && !this.assertCondition(node, entry.getCondition())) {
                log.info("Condition '{}' not matched, skipping", (Object)entry.getCondition());
                return Optional.empty();
            }
            Object nodesetResult = entry.getXPath().evaluate(node, XPathConstants.NODESET);
            result = entry.getChildren() != null && !entry.getChildren().isEmpty() ? this.mapChildren(nodesetResult, entry) : Optional.ofNullable(this.handleEvaluationResult(nodesetResult, entry.getFieldName()));
            if (result.isPresent()) {
                log.trace("Found nodeset result: {}", result.get());
            }
        }
        catch (XPathExpressionException e) {
            log.debug("Error selecting field {} as nodeset, could be XPath 2.0 expression... trying evaluation to string. Error was: {}", (Object)entry.getFieldName(), (Object)e.getMessage());
            log.trace("Error selecting field {} as nodeset", (Object)entry.getFieldName(), (Object)e);
        }
        if (!result.isPresent()) {
            try {
                String stringResult = (String)entry.getXPath().evaluate(node, XPathConstants.STRING);
                result = Optional.ofNullable(this.handleEvaluationResult(stringResult, entry.getFieldName()));
                if (result.isPresent()) {
                    log.trace("Found string result: {}", result.get());
                }
            }
            catch (XPathExpressionException e) {
                log.warn("Error selecting field {} as string: {}", (Object)entry.getFieldName(), (Object)e.getMessage());
                log.trace("Error selecting field {} as string", (Object)entry.getFieldName(), (Object)e);
            }
        }
        if (result.isPresent()) {
            EvalResult er = (EvalResult)result.get();
            if (entry.hasReplacements()) {
                er = this.handleReplacements(entry, er);
            }
            if (entry.hasSplit()) {
                er = this.handleSplit(entry, er);
            }
            result = Optional.of(er);
        }
        return result;
    }

    private Optional<EvalResult> mapChildren(Object nodesetResult, MappingEntry entry) {
        Optional<EvalResult> result;
        List<Node> nodes;
        if (nodesetResult instanceof NodeList) {
            NodeList tmp = (NodeList)nodesetResult;
            nodes = new ArrayList<Node>(tmp.getLength());
            for (int i = 0; i < tmp.getLength(); ++i) {
                nodes.add(tmp.item(i));
            }
        } else if (nodesetResult instanceof Node) {
            nodes = Collections.singletonList((Node)nodesetResult);
        } else {
            log.warn("nodesetResult type {} not supported", nodesetResult.getClass());
            nodes = Collections.emptyList();
        }
        List value = nodes.stream().map(n -> entry.getChildren().stream().map(me -> this.mapEntry((MappingEntry)me, (Node)n).orElse(null)).filter(me -> me != null).collect(Collectors.toMap(EvalResult::getName, EvalResult::getValue))).collect(Collectors.toList());
        if (value.size() == 1) {
            result = Optional.of(new EvalResult(entry.getFieldName(), value.get(0)));
        } else {
            if (value.isEmpty()) {
                return Optional.empty();
            }
            result = Optional.of(new EvalResult(entry.getFieldName(), value));
        }
        return result;
    }

    private EvalResult handleReplacements(MappingEntry entry, EvalResult er) {
        EvalResult result = null;
        Map<String, String> replacements = entry.getReplacements();
        log.trace("Applying replacements in {}: {}", (Object)er.name, (Object)Arrays.toString(replacements.entrySet().toArray()));
        if (er.value instanceof String) {
            result = new EvalResult(er.name, this.applyReplacements(replacements, (String)er.value));
        } else if (er.value instanceof String[]) {
            String[] val = (String[])er.value;
            result = new EvalResult(er.name, Arrays.stream(val).map(currentVal -> this.applyReplacements(replacements, (String)currentVal)).collect(Collectors.toList()).toArray());
        } else if (er.value instanceof Object[]) {
            Object[] val = (Object[])er.value;
            result = new EvalResult(er.name, Arrays.stream(val).filter(v -> v instanceof String).filter(Objects::nonNull).map(v -> (String)v).map(currentVal -> this.applyReplacements(replacements, (String)currentVal)).collect(Collectors.toList()).toArray());
        }
        log.trace("Result after replacements: {} (if null, then the original is returned)", (Object)result);
        if (result != null) {
            return result;
        }
        log.debug("No handling of replacement for given result implemented, returning input again: {}", (Object)er);
        return er;
    }

    private String applyReplacements(Map<String, String> replacements, String in) {
        String out = in;
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            out = out.replace(replacement.getKey(), replacement.getValue());
        }
        return out.trim();
    }

    private EvalResult handleSplit(MappingEntry entry, EvalResult er) {
        if (er.value instanceof String) {
            String value = (String)er.value;
            log.trace("Applying split in field {} with '{}' on {}", new Object[]{entry.getFieldName(), entry.getSplit(), value});
            String[] split = value.split(entry.getSplit());
            List list = Arrays.asList(split).stream().map(t -> t.trim()).collect(Collectors.toList());
            log.trace("Split resulted in {} items: {}", (Object)list.size(), (Object)Arrays.toString(list.toArray()));
            return new EvalResult(er.name, list);
        }
        log.trace("Split can only be applied to string value, but result was {} ({})", er.value, er.value.getClass());
        return er;
    }

    private boolean assertCondition(Node node, XPathExpression condition) throws XPathExpressionException {
        Object nodesetResult = condition.evaluate(node, XPathConstants.NODESET);
        Optional<EvalResult> result = Optional.ofNullable(this.handleEvaluationResult(nodesetResult, "condition"));
        if (!result.isPresent()) {
            log.info("condition did not fulfill: {}", (Object)condition);
        } else {
            log.info("conditiion fulfilled! {}", (Object)condition);
        }
        return result.isPresent();
    }

    private EvalResult handleEvaluationResult(Object evalutationResult, String name) {
        if (evalutationResult instanceof String) {
            String valueString = (String)evalutationResult;
            if (!valueString.isEmpty()) {
                log.trace("Found field {} = {}", (Object)name, (Object)valueString);
                return new EvalResult(name, valueString);
            }
            log.debug("Evaluation returned empty string for entry {}", (Object)name);
        } else if (evalutationResult instanceof NodeList) {
            NodeList nodeList = (NodeList)evalutationResult;
            Optional<Object> value = Optional.empty();
            if (nodeList.getLength() < 1) {
                log.debug("Evaluation returned no results for entry {}", (Object)name);
            } else {
                HashSet contents = Sets.newHashSet();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node n = nodeList.item(i);
                    String textContent = n.getTextContent();
                    if (textContent == null || textContent.isEmpty()) continue;
                    contents.add(textContent);
                }
                log.trace("{} evaluation result(s): {} = {}", new Object[]{contents.size(), name, Arrays.toString(contents.toArray())});
                if (contents.size() == 1) {
                    value = Optional.of(contents.iterator().next());
                    log.trace("Adding field {} = '{}'", (Object)name, value.get());
                }
                if (contents.size() > 1) {
                    value = Optional.of(contents.toArray());
                    log.trace("Adding array field ({} values) {} = {}", new Object[]{contents.size(), name, Arrays.toString(contents.toArray())});
                }
            }
            if (value.isPresent()) {
                return new EvalResult(name, value.get());
            }
            log.trace("No result found for field {}", (Object)name);
        } else {
            log.debug("Unsupported evalutation result: {}", evalutationResult);
        }
        return null;
    }

    public String mapRawEntry(MappingEntry entry, Node node) throws XPathExpressionException {
        Node nodesetResult = (Node)entry.getXPath().evaluate(node, XPathConstants.NODE);
        HashMap outputProperties = Maps.newHashMap();
        outputProperties.putAll(DEFAULT_OUTPUT_PROPERTIES);
        if (entry.hasOutputProperties()) {
            outputProperties.putAll(entry.getOutputProperties());
        }
        String xmldoc = this.asString(nodesetResult, outputProperties);
        log.trace("Storing full XML to field {} starting with {}", (Object)entry.getFieldName(), (Object)xmldoc.substring(0, Math.min(xmldoc.length(), 120)));
        return xmldoc;
    }

    private String asString(Node node, Map<String, String> outputProperties) {
        log.debug("Converting node {} to string using properties {}", (Object)node, (Object)Arrays.toString(outputProperties.entrySet().toArray()));
        StringWriter sw = new StringWriter();
        try {
            Transformer t = null;
            if (outputProperties.get("indent").equals("no") && this.stripspaceTransformer.isPresent()) {
                t = this.stripspaceTransformer.get();
                log.trace("Will apply stripspace XSLT.");
            } else {
                t = this.defaultTransformer;
            }
            for (Map.Entry<String, String> op : outputProperties.entrySet()) {
                t.setOutputProperty(op.getKey(), op.getValue());
            }
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException e) {
            log.warn("Problem getting node {} as string", (Object)node, (Object)e);
        }
        return sw.toString();
    }

    public static class EvalResult {
        protected final String name;
        protected final Object value;

        public EvalResult(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.value).omitNullValues().toString();
        }
    }
}

