/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.transform.impl;

import com.github.autermann.yaml.YamlNode;
import com.github.autermann.yaml.nodes.YamlMapNode;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import org.n52.youngs.exception.MappingError;
import org.n52.youngs.impl.NamespaceContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamespacedYamlConfiguration {
    private static final Logger log = LoggerFactory.getLogger(NamespacedYamlConfiguration.class);

    protected final NamespaceContext parseNamespaceContext(YamlNode configurationNodes) {
        if (configurationNodes.hasNotNull("namespaces")) {
            HashMap nsMap = Maps.newHashMap();
            YamlMapNode valueMap = configurationNodes.path("namespaces").asMap();
            valueMap.entries().stream().forEach(e -> nsMap.put(((YamlNode)e.getKey()).asTextValue(), ((YamlNode)e.getValue()).asTextValue()));
            NamespaceContextImpl nsc = new NamespaceContextImpl(nsMap);
            log.trace("Created namespace context from mapping configuration: {}", (Object)nsc);
            return nsc;
        }
        log.error("Requited namespace map missing in mapping file '{}'", (Object)configurationNodes.get("name"));
        throw new MappingError("Mapping '%s' does not contain 'namespaces' map.", configurationNodes.get("name"));
    }
}

