/*
 * Decompiled with CFR 0.152.
 */
package org.n52.youngs.validation;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class XmlSchemaValidator {
    private static final Logger LOG = LoggerFactory.getLogger((String)XmlSchemaValidator.class.getName());
    private final Schema schema;
    private final String namespace;
    private Validator validator;

    public XmlSchemaValidator(String namespace, URL ... schemaResources) throws SAXException {
        Objects.nonNull(schemaResources);
        Objects.nonNull(namespace);
        this.namespace = namespace;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.schema = schemaFactory.newSchema(this.convertToSources(schemaResources));
        this.initValidator();
    }

    public XmlSchemaValidator(String namespace, File ... schemaFiles) throws SAXException {
        Objects.nonNull(schemaFiles);
        Objects.nonNull(namespace);
        this.namespace = namespace;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.schema = schemaFactory.newSchema(this.convertToSources(schemaFiles));
        this.initValidator();
    }

    private void initValidator() {
        this.validator = this.schema.newValidator();
        String validationFeature = "http://xml.org/sax/features/validation";
        String schemaFeature = "http://apache.org/xml/features/validation/schema";
        try {
            this.validator.setFeature(validationFeature, true);
            this.validator.setFeature(schemaFeature, true);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
            LOG.warn("Could not enabled specific validation feature: " + ex.getMessage());
            LOG.debug(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean matchesNamespace(String uri) {
        return this.namespace.endsWith(uri);
    }

    public List<String> validate(Node xmlFile) throws SAXException, IOException {
        LocalErrorHandler eh = new LocalErrorHandler();
        this.validator.setErrorHandler(eh);
        this.validator.validate(new DOMSource(xmlFile));
        if (eh.errors.isEmpty() && eh.fatalErrors.isEmpty()) {
            return eh.warnings.stream().map(e -> e.getMessage()).collect(Collectors.toList());
        }
        if (eh.fatalErrors.isEmpty()) {
            SAXParseException e2 = (SAXParseException)eh.errors.get(0);
            throw new SAXException(e2.getMessage(), e2);
        }
        SAXParseException e3 = (SAXParseException)eh.fatalErrors.get(0);
        throw new SAXException(e3.getMessage(), e3);
    }

    private Source[] convertToSources(URL[] schemaResources) throws SAXException {
        ArrayList exceptions = Lists.newArrayList();
        Source[] result = Arrays.asList(schemaResources).stream().map(sr -> {
            try {
                return new StreamSource(sr.openStream());
            }
            catch (IOException ex) {
                exceptions.add(ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new StreamSource[0]);
        if (!exceptions.isEmpty()) {
            throw new SAXException((Exception)exceptions.get(0));
        }
        return result;
    }

    private Source[] convertToSources(File[] schemaResources) throws SAXException {
        Source[] result = Arrays.asList(schemaResources).stream().map(sr -> new StreamSource((File)sr)).collect(Collectors.toList()).toArray(new StreamSource[0]);
        return result;
    }

    private class LocalErrorHandler
    implements ErrorHandler {
        private final List<SAXParseException> warnings = Lists.newArrayList();
        private final List<SAXParseException> errors = Lists.newArrayList();
        private final List<SAXParseException> fatalErrors = Lists.newArrayList();

        private LocalErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.warnings.add(exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.fatalErrors.add(exception);
        }
    }
}

