/*
 * Decompiled with CFR 0.152.
 */
package org.naike.dtcache.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.naike.dtcache.Cache;
import org.naike.dtcache.callback.CacheItemChangeCallback;
import org.naike.dtcache.config.CacheConfig;
import org.naike.dtcache.core.CacheItem;
import org.naike.dtcache.daemon.CacheCleanDaemon;
import org.naike.dtcache.daemon.CacheSyncDaemon;
import org.naike.dtcache.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCache
implements Cache {
    private static List<Map<String, CacheItem>> cacheList = null;
    protected static Log logger = LogFactory.getLog(LocalCache.class);
    private static CacheConfig _config = null;
    private static Object initLock = new Object();
    private static boolean inited = false;
    private static boolean opened = false;

    public static void start(CacheConfig config) {
        _config = config;
        LocalCache.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Object object = initLock;
        synchronized (object) {
            LocalCache._init();
        }
    }

    private static void _init() {
        if (inited) {
            return;
        }
        inited = true;
        cacheList = new ArrayList<Map<String, CacheItem>>(_config.getHashSize());
        for (int i = 0; i < _config.getHashSize(); ++i) {
            cacheList.add(i, null);
        }
        CacheCleanDaemon cacheCleanDaemon = new CacheCleanDaemon(){

            @Override
            public List<Map<String, CacheItem>> getCache() {
                return cacheList;
            }

            @Override
            public boolean isExpire(CacheItem cacheItem) {
                return _config.getEpireStrategy().isExpire(cacheItem);
            }
        };
        cacheCleanDaemon.start();
        if (_config.getCacheItemListener() != null) {
            CacheSyncDaemon cacheSyncDaemon = new CacheSyncDaemon(){

                public void work() {
                    _config.getCacheItemListener().listen(new CacheItemChangeCallback(){

                        public void call(String className, String id) {
                            LocalCache._delete(className, id);
                        }
                    });
                }
            };
            cacheSyncDaemon.start();
        }
        opened = true;
    }

    private boolean check() {
        if (!inited) {
            throw new RuntimeException("cache not configure yet!!!");
        }
        return opened;
    }

    public static void close() {
        opened = false;
    }

    private static Map<String, CacheItem> getCache(String id) {
        long index = StringUtil.getHashCode(id) % (long)_config.getHashSize();
        Map<String, CacheItem> cache = cacheList.get((int)index);
        if (cache == null) {
            cache = new ConcurrentHashMap<String, CacheItem>();
            cacheList.add((int)index, cache);
        }
        return cache;
    }

    private static String getCacheKey(Class<?> cls, String id) {
        return LocalCache.getCacheKey(cls.getSimpleName(), id);
    }

    private static String getCacheKey(String className, String id) {
        return className + ":" + id;
    }

    public static void _delete(String className, String id) {
        logger.debug((Object)("delete from cache.className:" + className + ",id:" + id));
        LocalCache.getCache(id).remove(LocalCache.getCacheKey(className, id));
    }

    @Override
    public void delete(String className, String id) {
        if (_config.getCacheItemListener() == null) {
            LocalCache._delete(className, id);
        } else {
            _config.getCacheItemListener().onChange(className, id);
        }
    }

    @Override
    public void delete(Class<?> cls, String id) {
        this.delete(cls.getSimpleName(), id);
    }

    @Override
    public void put(String id, Object obj) {
        if (!this.check()) {
            return;
        }
        if (obj == null) {
            return;
        }
        logger.debug((Object)(obj.getClass().getSimpleName() + " store object with key:" + id));
        CacheItem item = new CacheItem(obj);
        LocalCache.getCache(id).put(LocalCache.getCacheKey(obj.getClass(), id), item);
    }

    @Override
    public <T> T get(String id, Class<T> cls) {
        if (!this.check()) {
            return null;
        }
        if (id == null || id.length() == 0) {
            return null;
        }
        CacheItem item = LocalCache.getCache(id).get(LocalCache.getCacheKey(cls, id));
        if (item != null) {
            logger.debug((Object)(cls.getSimpleName() + " cahce hit with key:" + id));
            item.readInc();
            item.setCacheTime(System.currentTimeMillis());
            return (T)item.getValue();
        }
        logger.debug((Object)(cls.getSimpleName() + " cahce miss with key:" + id));
        return null;
    }
}

