/*
 * Decompiled with CFR 0.152.
 */
package org.naike.dtcache.daemon;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.naike.dtcache.core.CacheItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheCleanDaemon
extends Thread {
    protected static Log logger = LogFactory.getLog(CacheCleanDaemon.class);

    private void memoryUseage() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        String msg = MessageFormat.format("Max Memory:{0,}MB;Total Memory:{1}MB;Free Memory:{2}MB", maxMemory / 1024L / 1024L, totalMemory / 1024L / 1024L, freeMemory / 1024L / 1024L);
        logger.debug((Object)msg);
    }

    private void cleanExpired() {
        List<Map<String, CacheItem>> cacheList = this.getCache();
        int total = 0;
        int clean = 0;
        for (Map<String, CacheItem> m : cacheList) {
            if (m == null) continue;
            total += m.size();
            ArrayList<String> expiredKeys = new ArrayList<String>();
            for (Map.Entry<String, CacheItem> entry : m.entrySet()) {
                CacheItem cacheItem = entry.getValue();
                if (!this.isExpire(cacheItem)) continue;
                expiredKeys.add(entry.getKey());
            }
            for (String key : expiredKeys) {
                ++clean;
                m.remove(key);
            }
        }
        String msg = MessageFormat.format("Total Cache Item:{0};Expired Item: {1}, New Total Item: {2}", total, clean, total - clean);
        logger.debug((Object)msg);
    }

    public abstract List<Map<String, CacheItem>> getCache();

    public abstract boolean isExpire(CacheItem var1);

    private void work() {
        this.memoryUseage();
        this.cleanExpired();
        this.memoryUseage();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.work();
                    Thread.sleep(30000L);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    logger.error((Object)ie.getMessage(), (Throwable)ie);
                    continue;
                }
            }
            break;
        }
    }
}

