/*
 * Decompiled with CFR 0.152.
 */
package org.naike.dtcache.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.naike.dtcache.callback.CacheItemChangeCallback;
import org.naike.dtcache.listener.CacheItemListener;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public abstract class CacheItemListenerRedisImpl
implements CacheItemListener {
    protected static Log logger = LogFactory.getLog(CacheItemListenerRedisImpl.class);
    public static final String MEMORY_CACHE_RECORD_CHANGE_CHANNEL = "memory-cache-record-change-channel";

    public abstract Jedis getRedis();

    public abstract void closeRedis(Jedis var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(String className, String id) {
        Jedis jedis = this.getRedis();
        try {
            String message = className + ":" + id;
            logger.debug((Object)("publish message:" + message));
            jedis.publish(MEMORY_CACHE_RECORD_CHANGE_CHANNEL, message);
        }
        finally {
            this.closeRedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(final CacheItemChangeCallback callback) {
        Jedis jedis = this.getRedis();
        try {
            jedis.subscribe((JedisPubSub)new JedisPubSubImpl(){

                public void onMessage(String channel, String message) {
                    logger.debug((Object)("message:" + message));
                    String[] datas = message.split(":");
                    callback.call(datas[0], datas[1]);
                }
            }, new String[]{MEMORY_CACHE_RECORD_CHANGE_CHANNEL});
        }
        finally {
            this.closeRedis(jedis);
        }
    }

    abstract class JedisPubSubImpl
    extends JedisPubSub {
        JedisPubSubImpl() {
        }

        public void onPMessage(String pattern, String channel, String message) {
        }

        public void onSubscribe(String channel, int subscribedChannels) {
        }

        public void onUnsubscribe(String channel, int subscribedChannels) {
        }

        public void onPUnsubscribe(String pattern, int subscribedChannels) {
        }

        public void onPSubscribe(String pattern, int subscribedChannels) {
        }
    }
}

