package org.nakedobjects.applib.value;

import java.io.Serializable;

import org.nakedobjects.applib.annotation.MultiLine;
import org.nakedobjects.applib.annotation.Value;


@Value(semanticsProviderName = "org.nakedobjects.metamodel.value.MultilineStringValueSemanticsProvider")
@MultiLine(numberOfLines = 6, preventWrapping = false)
public class MultilineString implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String string;

    public MultilineString(final String string) {
        this.string = string;
    }

    public String getString() {
        return string;
    }

    @Override
    public boolean equals(final Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other.getClass() == this.getClass() && equals((MultilineString) other);
    }

    public boolean equals(final MultilineString other) {
        final String otherString = other.getString();
        if (getString() == null && otherString == null) {
            return true;
        }
        if (getString() == null || otherString == null) {
            return false;
        }
        return getString().equals(otherString);
    }

    @Override
    public int hashCode() {
        return string != null ? string.hashCode() : 0;
    }

    @Override
    public String toString() {
        return string;
    }
}
// Copyright (c) Naked Objects Group Ltd.
