/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.value;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nakedobjects.applib.value.DateTime;
import org.nakedobjects.applib.value.Magnitude;
import org.nakedobjects.applib.value.TestClock;

public class DateTimeTest {
    private DateTime actual;

    @Before
    public void setUp() throws Exception {
        TestClock.initialize();
        this.actual = new DateTime(2000, 3, 14, 10, 45);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetDay() {
        Assert.assertEquals((long)14L, (long)this.actual.getDay());
    }

    @Test
    public void testGetMonth() {
        Assert.assertEquals((long)3L, (long)this.actual.getMonth());
    }

    @Test
    public void testGetYear() {
        Assert.assertEquals((long)2000L, (long)this.actual.getYear());
    }

    @Test
    public void test24Hour() {
        DateTime dt = new DateTime(2006, 5, 7, 23, 59);
        Assert.assertEquals((String)"hour", (long)23L, (long)dt.getHour());
        Assert.assertEquals((String)"minute", (long)59L, (long)dt.getMinute());
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testAdd() {
    }

    @Ignore(value="TODO: may not work")
    @Test
    public void testEquals() throws Exception {
        Assert.assertTrue((boolean)this.actual.equals((Object)this.actual));
        Assert.assertTrue((boolean)new DateTime(2003, 8, 17).equals((Object)new DateTime()));
        Assert.assertTrue((boolean)this.actual.equals((Object)new DateTime(2000, 3, 14, 10, 45)));
    }

    @Ignore(value="TODO: may not work")
    @Test
    public void testIsLestThan() throws Exception {
        Assert.assertFalse((boolean)new DateTime(2003, 8, 17).isLessThan((Magnitude)new DateTime(2003, 8, 17)));
        Assert.assertTrue((boolean)new DateTime(2003, 8, 16).isLessThan((Magnitude)new DateTime(2003, 8, 17)));
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testSameDayOfWeekAs() throws Exception {
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testSameDayOfMonthAs() throws Exception {
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testSameDayOfYearAs() throws Exception {
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testSameWeekAs() throws Exception {
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testSameMonthAs() throws Exception {
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testSameYearAs() throws Exception {
    }

    @Ignore(value="TODO: may not work")
    @Test
    public void testDateTimeValue() {
        DateTime date = new DateTime(1970, 1, 1);
        Assert.assertEquals((long)1970L, (long)date.getYear());
        Assert.assertEquals((long)1L, (long)date.getMonth());
        Assert.assertEquals((long)1L, (long)date.getDay());
        long time = date.dateValue().getTime();
        Assert.assertEquals((long)0L, (long)time);
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testStartOfYear() {
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testStartOfMonth() {
    }

    @Ignore(value="TODO: need to reinstate functionality")
    @Test
    public void testStartOfWeek() {
    }

    @Ignore(value="TODO: may not work")
    @Test
    public void testNewWithTodaysDateTime() {
        DateTime actual = new DateTime();
        DateTime expected = new DateTime(2003, 8, 17);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Ignore(value="TODO: may not work")
    @Test
    public void testToString() {
        Assert.assertEquals((Object)"2000-3-14", (Object)this.actual.toString());
    }
}

