/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nakedobjects.applib.annotation.MemberOrder;
import org.nakedobjects.applib.annotation.NotPersistable;
import org.nakedobjects.applib.security.RoleMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotPersistable
public final class UserMemento {
    private final String name;
    private final List<RoleMemento> roles = new ArrayList<RoleMemento>();

    public UserMemento(String name) {
        this(name, new RoleMemento[0]);
    }

    public UserMemento(String name, RoleMemento ... roles) {
        if (name == null) {
            throw new IllegalArgumentException("Name not specified");
        }
        this.name = name;
        this.roles.addAll(Arrays.asList(roles));
    }

    public String title() {
        return this.name;
    }

    @MemberOrder(sequence="1.1")
    public String getName() {
        return this.name;
    }

    public boolean isCurrentUser(String user) {
        if (user == null) {
            throw new IllegalStateException("no user specified");
        }
        return this.name.equals(user);
    }

    @MemberOrder(sequence="1.1")
    public List<RoleMemento> getRoles() {
        return this.roles;
    }

    public boolean hasRole(RoleMemento role) {
        return this.hasRole(role.getName());
    }

    public boolean hasRole(String roleName) {
        for (RoleMemento role : this.roles) {
            if (!role.getName().equals(roleName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (RoleMemento role : this.roles) {
            buf.append(role.getName()).append(" ");
        }
        return "User [name=" + this.getName() + ",roles=" + buf.toString() + "]";
    }
}

