/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.applib.AbstractContainedObject;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.applib.security.UserMemento;

public class ContainedObjectTest {
    private DomainObjectContainer container;
    private AbstractContainedObject object;
    private Mockery context;

    @Before
    public void setUp() throws Exception {
        this.context = new Mockery();
        this.container = (DomainObjectContainer)this.context.mock(DomainObjectContainer.class);
        this.object = new AbstractContainedObject(){};
        this.object.setContainer(this.container);
    }

    @Test
    public void testContainer() throws Exception {
        Assert.assertEquals((Object)this.container, (Object)this.object.getContainer());
    }

    @Test
    public void testInformUser() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DomainObjectContainer)this.one(ContainedObjectTest.this.container)).informUser("message");
            }
        });
        this.object.informUser("message");
        this.context.assertIsSatisfied();
    }

    @Test
    public void testWarnUser() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DomainObjectContainer)this.one(ContainedObjectTest.this.container)).warnUser("message");
            }
        });
        this.object.warnUser("message");
        this.context.assertIsSatisfied();
    }

    @Test
    public void testRaiseError() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DomainObjectContainer)this.one(ContainedObjectTest.this.container)).raiseError("message");
            }
        });
        this.object.raiseError("message");
        this.context.assertIsSatisfied();
    }

    @Test
    public void testGetUser() throws Exception {
        final UserMemento memento = new UserMemento("Harry");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DomainObjectContainer)this.one(ContainedObjectTest.this.container)).getUser();
                this.will(5.returnValue((Object)memento));
            }
        });
        UserMemento user = this.object.getUser();
        Assert.assertEquals((Object)memento, (Object)user);
        this.context.assertIsSatisfied();
    }
}

