/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.value;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.nakedobjects.applib.annotation.Value;
import org.nakedobjects.applib.clock.Clock;
import org.nakedobjects.applib.value.Magnitude;

@Value(semanticsProviderName="org.nakedobjects.metamodel.value.TimeValueSemanticsProvider")
public class Time
extends Magnitude {
    private static final long serialVersionUID = 1L;
    public static final int MINUTE = 60;
    public static final int HOUR = 3600;
    public static final int DAY = 86400;
    private static final DateFormat SHORT_FORMAT = DateFormat.getTimeInstance(3);
    private static final long zero;
    private static final TimeZone UtcTimeZone;
    private final Date date;

    static long getZero() {
        return zero / 1000L;
    }

    public Time() {
        Calendar cal = this.createCalendar();
        cal.setTimeZone(TimeZone.getDefault());
        cal.setTime(new Date(Clock.getTime()));
        this.date = this.time(cal.get(11), cal.get(12));
    }

    public Time(int hour, int minute) {
        this.date = this.time(hour, minute);
    }

    private Date time(int hour, int minute) {
        this.checkTime(hour, minute, 0);
        Calendar cal = this.createCalendar();
        cal.setTimeZone(UtcTimeZone);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(1, 1970);
        return cal.getTime();
    }

    public Time(Date date) {
        Calendar localTime = this.createCalendar();
        localTime.setTimeZone(UtcTimeZone);
        localTime.setTime(date);
        this.date = this.time(localTime.get(11), localTime.get(12));
    }

    public Time add(int hours, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(12, minutes);
        cal.add(11, hours);
        return this.createTime(cal.getTime());
    }

    private void checkTime(int hour, int minute, int second) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour must be in the range 0 - 23 inclusive");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute must be in the range 0 - 59 inclusive");
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Second must be in the range 0 - 59 inclusive");
        }
    }

    private Calendar createCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(UtcTimeZone);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(5, 1);
        cal.clear(9);
        cal.clear(10);
        cal.set(2, 0);
        cal.set(1, 1970);
        return cal;
    }

    protected Time createTime(int hours, int minutes) {
        return new Time(hours, minutes);
    }

    protected Time createTime(Date date) {
        return new Time(date);
    }

    public Date dateValue() {
        return this.date == null ? null : this.date;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Time)) {
            return false;
        }
        Time object = (Time)obj;
        return object.date.equals(this.date);
    }

    public int getHour() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UtcTimeZone);
        c.setTime(this.date);
        return c.get(11);
    }

    public int getMinute() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UtcTimeZone);
        c.setTime(this.date);
        return c.get(12);
    }

    public boolean isEqualTo(Magnitude time) {
        if (time instanceof Time) {
            return this.date == null ? false : this.date.equals(((Time)time).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public boolean isLessThan(Magnitude time) {
        if (time instanceof Time) {
            return this.date != null && this.date.before(((Time)time).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public long longValue() {
        return this.date.getTime() / 1000L;
    }

    public String titleString() {
        return this.date == null ? "" : SHORT_FORMAT.format(this.date);
    }

    public String toString() {
        return this.getHour() + ":" + this.getMinute();
    }

    public boolean sameHourAs(Time time) {
        return this.getHour() == time.getHour();
    }

    public boolean sameMinuteAs(Time time) {
        return this.getMinute() == time.getMinute();
    }

    public Time onTheHour() {
        return this.createTime(this.getHour(), 0);
    }

    static {
        UtcTimeZone = TimeZone.getTimeZone("Etc/UTC");
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(UtcTimeZone);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        cal.clear(9);
        cal.clear(10);
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(1, 1970);
        zero = cal.getTime().getTime();
        SHORT_FORMAT.setTimeZone(UtcTimeZone);
    }
}

