package org.nakedobjects.applib.fixtures;


/**
 * Indicates that the demo or test should be run as the specified user, with
 * the specified roles.
 * 
 * <p>
 * Note: this fixture does not in itself do anything (its {@link #install()} is a
 * no-op).  However, if present in the fixture list then is &quot;noticed&quot; by the framework,
 * and is used to automatically logon when the framework is booted (providing running in
 * prototype or exploration, not in production).
 * 
 * <p>
 * To change the user during the installation of fixtures, either use {@link SwitchUserFixture}.
 * 
 * @see SwitchUserFixture
 */
public class LogonFixture implements InstallableFixture {

    public LogonFixture(final String username, final String... roles) {
        this.username = username;
        this.roles = roles;
    }

    private final String username;
    public String getUsername() {
        return username;
    }

    private final String[] roles;
    public String[] getRoles() {
        return roles;
    }

    public final void install() {
        // does nothing; see comments above.
    }

    @Override
    public String toString() {
    	return "LogonFixture [user: " + getUsername() + ", roles: " + getRoles() + "]";
    }

	public FixtureType getType() {
		return FixtureType.OTHER;
	}
}
