/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.value;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.applib.value.Magnitude;
import org.nakedobjects.applib.value.Money;

public class MoneyTest {
    @Test
    public void testAdd() {
        Money m1 = new Money(110L, "pds");
        Money m2 = new Money(220L, "pds");
        Money m3 = m1.add(m2);
        Assert.assertEquals((double)330.0, (double)m3.doubleValue(), (double)0.0);
    }

    @Test
    public void testAddWithCents() {
        Money m1 = new Money(110.1, "pds");
        Money m2 = new Money(220.5, "pds");
        Money m3 = m1.add(m2);
        Assert.assertEquals((double)330.6, (double)m3.doubleValue(), (double)0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddThrowsExceptionForDifferentCurrencies() {
        Money m1 = new Money(100L, "pds");
        Money m2 = new Money(200L, "uds");
        m1.add(m2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleConstructorExpectsCurrencyToBeSpecified() {
        new Money(100.5, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLongConstructorExpectsCurrencyToBeSpecified() {
        new Money(100L, null);
    }

    @Test
    public void testCreateFromDouble() {
        Money m1 = new Money(100.5, "pds");
        Assert.assertEquals((Object)"100.50", (Object)m1.getAmount().toString());
        Assert.assertEquals((double)100.5, (double)m1.doubleValue(), (double)0.0);
    }

    @Test
    public void testDouble() {
        Money m1 = new Money(100L, "pds");
        Assert.assertEquals((double)100.0, (double)m1.doubleValue(), (double)0.0);
    }

    @Test
    public void testDoubleConstructor() {
        Money m1 = new Money(100.15, "pds");
        Assert.assertEquals((double)100.15, (double)m1.doubleValue(), (double)0.0);
    }

    @Test
    public void testDoubleRoundingDown() {
        Money m1 = new Money(100.154, "pds");
        Assert.assertEquals((double)100.15, (double)m1.doubleValue(), (double)0.0);
    }

    @Test
    public void testDoubleRoundingUp() {
        Money m1 = new Money(100.156, "pds");
        Assert.assertEquals((double)100.16, (double)m1.doubleValue(), (double)0.0);
    }

    @Test
    public void testEqualsObject() {
        Money m1 = new Money(100.25, "pds");
        Money m2 = new Money(100.25, "pds");
        Assert.assertTrue((boolean)m1.equals(m2));
    }

    @Test
    public void testEqualsObjectFailsWithDifferentAmounts() {
        Money m1 = new Money(100L, "pds");
        Money m2 = new Money(101L, "pds");
        Assert.assertFalse((boolean)m1.equals(m2));
    }

    @Test
    public void testEqualsObjectFailsWithDifferentCurrencies() {
        Money m1 = new Money(100L, "pds");
        Money m2 = new Money(100L, "usd");
        Assert.assertFalse((boolean)m1.equals(m2));
    }

    @Test
    public void testGetAmount() {
        Money m1 = new Money(100L, "pds");
        Assert.assertEquals((Object)BigDecimal.valueOf(10000L, 2), (Object)m1.getAmount());
    }

    @Test
    public void testHasSameCurrency() {
        Money m1 = new Money(100L, "pds");
        Money m2 = new Money(200L, "pds");
        Money m3 = new Money(200L, "usd");
        Assert.assertTrue((boolean)m1.hasSameCurrency(m2));
        Assert.assertFalse((boolean)m1.hasSameCurrency(m3));
    }

    @Test
    public void testIsEqualTo() {
        Money m1 = new Money(100L, "pds");
        Money m2 = new Money(100L, "pds");
        Assert.assertTrue((boolean)m1.isEqualTo((Magnitude)m2));
    }

    @Test
    public void testIsEqualToFailsWithDifferentAmount() {
        Money m1 = new Money(100L, "pds");
        Money m2 = new Money(101L, "pds");
        Assert.assertFalse((boolean)m1.isEqualTo((Magnitude)m2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsEqualToThrowsExceptionWithDifferentCurrencies() {
        Money m1 = new Money(100L, "pds");
        Money m2 = new Money(100L, "usd");
        m1.isEqualTo((Magnitude)m2);
    }

    @Test
    public void testIsGreaterThanZero() {
        Money m1 = new Money(1L, "usd");
        Assert.assertTrue((boolean)m1.isGreaterThanZero());
    }

    @Test
    public void testIsGreaterThanZeroFailsWhenZero() {
        Money m1 = new Money(0L, "usd");
        Assert.assertFalse((boolean)m1.isGreaterThanZero());
    }

    @Test
    public void testIsLessThan() {
        Money m1 = new Money(98L, "pds");
        Money m2 = new Money(100L, "pds");
        Assert.assertTrue((boolean)m1.isLessThan((Magnitude)m2));
    }

    @Test
    public void testIsLessThanFails() {
        Money m1 = new Money(98L, "pds");
        Money m2 = new Money(100L, "pds");
        Assert.assertFalse((boolean)m2.isLessThan((Magnitude)m1));
    }

    @Test
    public void testIsLessThanZero() {
        Money m1 = new Money(-1L, "usd");
        Assert.assertTrue((boolean)m1.isLessThanZero());
    }

    @Test
    public void testIsLessThanZeroFailsWhenZero() {
        Money m1 = new Money(0L, "usd");
        Assert.assertFalse((boolean)m1.isLessThanZero());
    }

    public void testIsLessThrowsExceptionWithDifferentCurrencies() {
        Money m1 = new Money(98L, "pds");
        Money m2 = new Money(100L, "usd");
        try {
            m2.isLessThan((Magnitude)m1);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIsZero() {
        Money m1 = new Money(0L, "usd");
        Assert.assertTrue((boolean)m1.isZero());
    }

    @Test
    public void testIsZeroFailsWhenPositive() {
        Money m1 = new Money(1L, "usd");
        Assert.assertFalse((boolean)m1.isZero());
    }

    @Test
    public void testSubtract() {
        Money m1 = new Money(300L, "pds");
        Money m2 = new Money(100L, "pds");
        Money m3 = m1.subtract(m2);
        Assert.assertEquals((double)200.0, (double)m3.doubleValue(), (double)0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubtractThrowsExceptionForDifferentCurrencies() {
        Money m1 = new Money(100L, "pds");
        Money m2 = new Money(200L, "uds");
        m1.subtract(m2);
    }
}

