/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib;

import org.nakedobjects.applib.util.NameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identifier
implements Comparable<Identifier> {
    public static final int CLASS = 0;
    public static final int CLASS_NAME = 1;
    public static final int CLASS_NAME_PARMS = 2;
    public static final int NAME = 3;
    public static final int PARMS = 4;
    private final String className;
    private final String memberName;
    private final String[] parameterNames;
    private final Type type;
    private String identityString;
    private String asString = null;

    public static Identifier classIdentifier(Class<?> clazz) {
        return Identifier.classIdentifier(clazz.getName());
    }

    public static Identifier classIdentifier(String className) {
        return new Identifier(className, "", new String[0], Type.CLASS);
    }

    public static Identifier propertyOrCollectionIdentifier(Class<?> declaringClass, String propertyOrCollectionName) {
        return Identifier.propertyOrCollectionIdentifier(declaringClass.getCanonicalName(), propertyOrCollectionName);
    }

    public static Identifier propertyOrCollectionIdentifier(String declaringClassName, String propertyOrCollectionName) {
        return new Identifier(declaringClassName, propertyOrCollectionName, new String[0], Type.PROPERTY_OR_COLLECTION);
    }

    public static Identifier actionIdentifier(Class<?> declaringClass, String actionName, Class<?>[] parameterClasses) {
        return Identifier.actionIdentifier(declaringClass.getCanonicalName(), actionName, Identifier.toParameterStringArray(parameterClasses));
    }

    public static Identifier actionIdentifier(String declaringClassName, String actionName, Class<?>[] parameterClasses) {
        return Identifier.actionIdentifier(declaringClassName, actionName, Identifier.toParameterStringArray(parameterClasses));
    }

    public static Identifier actionIdentifier(String declaringClassName, String actionName, String[] parameterClassNames) {
        return new Identifier(declaringClassName, actionName, parameterClassNames, Type.ACTION);
    }

    private static String[] toParameterStringArray(Class<?>[] parameterClasses) {
        String[] parameters = new String[parameterClasses == null ? 0 : parameterClasses.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = parameterClasses[i].getName();
        }
        return parameters;
    }

    private Identifier(String className, String memberName, String[] parameterNames, Type type) {
        this.className = className;
        this.memberName = memberName;
        this.parameterNames = parameterNames;
        this.type = type;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberNaturalName() {
        return NameUtils.naturalName(this.memberName);
    }

    public String[] getMemberParameterNames() {
        return this.parameterNames;
    }

    public String[] getMemberParameterNaturalNames() {
        return NameUtils.naturalNames(this.parameterNames);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPropertyOrCollection() {
        return this.type == Type.PROPERTY_OR_COLLECTION;
    }

    @Override
    public int compareTo(Identifier o2) {
        return this.toString().compareTo(o2.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Identifier) {
            Identifier other = (Identifier)obj;
            return this.equals(other.className, this.className) && this.equals(other.memberName, other.memberName) && this.equals(other.parameterNames, this.parameterNames);
        }
        return false;
    }

    private boolean equals(String[] a, String[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    private boolean equals(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    public String toIdentityString(int depth) {
        switch (depth) {
            case 0: {
                return this.toClassIdentityString();
            }
            case 1: {
                return this.toClassAndNameIdentityString();
            }
            case 2: {
                return this.toFullIdentityString();
            }
            case 3: {
                return this.toNameIdentityString();
            }
            case 4: {
                return this.toParmsIdentityString();
            }
        }
        return null;
    }

    public String toClassIdentityString() {
        return this.className;
    }

    public String toNameIdentityString() {
        return this.memberName;
    }

    public String toClassAndNameIdentityString() {
        return this.toClassIdentityString() + "#" + this.memberName;
    }

    public String toParmsIdentityString() {
        StringBuilder str = new StringBuilder();
        if (this.type == Type.ACTION) {
            str.append('(');
            for (int i = 0; i < this.parameterNames.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(this.parameterNames[i]);
            }
            str.append(')');
        }
        return str.toString();
    }

    public String toNameParmsIdentityString() {
        return this.getMemberName() + this.toParmsIdentityString();
    }

    public String toFullIdentityString() {
        if (this.identityString == null) {
            if (this.memberName.length() == 0) {
                this.identityString = this.toClassIdentityString();
            } else {
                StringBuilder str = new StringBuilder();
                str.append(this.toClassAndNameIdentityString());
                str.append(this.toParmsIdentityString());
                this.identityString = str.toString();
            }
        }
        return this.identityString;
    }

    public String toString() {
        if (this.asString == null) {
            StringBuilder str = new StringBuilder();
            str.append(this.className);
            str.append('#');
            str.append(this.memberName);
            str.append('(');
            for (int i = 0; i < this.parameterNames.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(this.parameterNames[i]);
            }
            str.append(')');
            this.asString = str.toString();
        }
        return this.asString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CLASS,
        PROPERTY_OR_COLLECTION,
        ACTION;

    }
}

