/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.fixtures;

import java.util.Calendar;
import java.util.TimeZone;
import org.nakedobjects.applib.clock.Clock;

public class FixtureClock
extends Clock {
    private static final TimeZone UTC_TIME_ZONE;
    private Calendar calendar = null;

    public static synchronized FixtureClock initialize() {
        if (!FixtureClock.isInitialized() || !(FixtureClock.getInstance() instanceof FixtureClock)) {
            new FixtureClock();
        }
        return (FixtureClock)FixtureClock.getInstance();
    }

    public static boolean remove() {
        return Clock.remove();
    }

    private FixtureClock() {
    }

    protected long time() {
        if (this.calendar == null) {
            return System.currentTimeMillis();
        }
        return this.calendar.getTime().getTime();
    }

    public void clear() {
        this.setupCalendarIfRequired();
        this.calendar.clear();
    }

    public void setTime(int hour, int min) {
        this.setupCalendarIfRequired();
        this.calendar.set(11, hour);
        this.calendar.set(12, min);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
    }

    public void setDate(int year, int month, int day) {
        this.setupCalendarIfRequired();
        this.calendar.set(1, year);
        this.calendar.set(2, month - 1);
        this.calendar.set(5, day);
    }

    public void addTime(int hours, int minutes) {
        this.setupCalendarIfRequired();
        this.calendar.add(11, hours);
        this.calendar.add(12, minutes);
    }

    public void addDate(int years, int months, int days) {
        this.setupCalendarIfRequired();
        this.calendar.add(1, years);
        this.calendar.add(2, months);
        this.calendar.add(5, days);
    }

    private void setupCalendarIfRequired() {
        if (this.calendar != null) {
            return;
        }
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(UTC_TIME_ZONE);
    }

    public void reset() {
        this.calendar = null;
    }

    public String toString() {
        return (this.calendar == null ? "System" : "Explicitly set") + ": " + Clock.getTimeAsCalendar().getTime().toString();
    }

    static {
        TimeZone tempTimeZone = TimeZone.getTimeZone("Etc/UTC");
        if (tempTimeZone == null) {
            tempTimeZone = TimeZone.getTimeZone("UTC");
        }
        UTC_TIME_ZONE = tempTimeZone;
    }
}

