/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.spec;

import java.lang.reflect.Method;
import org.nakedobjects.applib.spec.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpecification<T>
implements Specification {
    private final Class<?> expectedType = AbstractSpecification.findExpectedType(this.getClass());
    private final Nullability nullability;
    private final TypeChecking typeChecking;

    private static Class<?> findExpectedType(Class<?> fromClass) {
        for (Class<?> c = fromClass; c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if (!AbstractSpecification.isSatisfiesSafelyMethod(method)) continue;
                return method.getParameterTypes()[0];
            }
        }
        throw new Error("Cannot determine correct type for satisfiesSafely() method.");
    }

    private static boolean isSatisfiesSafelyMethod(Method method) {
        return method.getName().equals("satisfiesSafely") && method.getParameterTypes().length == 1 && !method.isSynthetic();
    }

    protected AbstractSpecification() {
        this(Nullability.IGNORE_IF_NULL, TypeChecking.IGNORE_INCORRECT_TYPE);
    }

    protected AbstractSpecification(Nullability nullability, TypeChecking typeChecking) {
        this.nullability = nullability;
        this.typeChecking = typeChecking;
    }

    @Override
    public final String satisfies(Object obj) {
        if (obj == null) {
            return this.nullability == Nullability.IGNORE_IF_NULL ? null : "Cannot be null";
        }
        if (!this.expectedType.isInstance(obj)) {
            return this.typeChecking == TypeChecking.IGNORE_INCORRECT_TYPE ? null : "Incorrect type";
        }
        Object objAsT = obj;
        return this.satisfiesSafely(objAsT);
    }

    public abstract String satisfiesSafely(T var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Nullability {
        ENSURE_NOT_NULL,
        IGNORE_IF_NULL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeChecking {
        ENSURE_CORRECT_TYPE,
        IGNORE_INCORRECT_TYPE;

    }
}

